% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefvariation.R
\name{tstab.cv}
\alias{tstab.cv}
\title{Coefficient of variation threshold stability plot}
\usage{
tstab.cv(
  xdat,
  thresh,
  method = c("empirical", "mle", "wcv", "cv"),
  nthresh = 10L,
  nsim = 99L,
  plot = TRUE,
  level = 0.95,
  ...
)
}
\arguments{
\item{xdat}{[vector] vector of observations}

\item{thresh}{[vector] vector of threshold. If missing, set to \eqn{p^k} for \eqn{k=0} to \eqn{k=}\code{nthresh}}

\item{method}{[string], either moment estimator for the (weighted) coefficient of variation (\code{wcv} and \code{cv}) or maximum likelihood (\code{mle})}

\item{nthresh}{[integer] number of thresholds, if \code{thresh} is not supplied by the user}

\item{nsim}{[integer] number of bootstrap replications}

\item{plot}{[logical] if \code{TRUE}, returns a plot of the p-value path}

\item{level}{[numeric] probability level for sequential testing procedure}

\item{...}{additional parameters, notably for package \code{boot}, for the \code{type} of confidence intervals.}
}
\description{
This function calculates parametric estimates of the coefficient of variation with pointwise Wald confidence intervals along with empirical estimates and returns a threshold stability plot.
}
\examples{
tstab.cv(
   xdat = rgp(1000),
   thresh = qgp(seq(0,0.9, by = 0.1)),
   method = "cv")
tstab.cv(
   xdat = rgp(1000),
   thresh = qgp(seq(0,0.9, by = 0.1)),
   method = "empirical")
}
