% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrl.R
\name{thselect.mrl}
\alias{thselect.mrl}
\title{Automated mean residual life plots}
\usage{
thselect.mrl(xdat, thresh, kmax, plot = TRUE, ...)
}
\arguments{
\item{xdat}{[numeric] vector of observations}

\item{thresh}{[numeric] vector of thresholds; if missing, uses all order statistics from the 20th largest until \code{kmax} as candidates}

\item{kmax}{[integer] maximum number of order statistics}

\item{plot}{[logical] if \code{TRUE} (default), return a plot of the mean residual life plot with the fitted slope
and the chosen threshold}

\item{...}{additional arguments, currently ignored}
}
\value{
a list containing
\itemize{
\item \code{thresh}: candidate threshold vector
\item \code{thresh0}: selected threshold
\item \code{scale}: scale parameter estimate
\item \code{shape}: shape parameter estimate
\item \code{mrl}: empirical mean excess values
\item \code{xdat}: ordered observations
\item \code{intercept}: intercept for mean excess value at chosen threshold
\item \code{slope}: slope for mean excess value at chosen threshold
\item \code{tmanual}: logical; \code{TRUE} if the user passed a vector of thresholds
}
}
\description{
This function implements the automated proposal from Section 2.2 of Langousis et al. (2016) for mean residual life plots. It returns the threshold that minimize the weighted mean square error and moment estimators for the scale and shape parameter based on weighted least squares.
}
\details{
The procedure consists in estimating the usual mean residual life as a function of the threshold, and looking for an order statistic or threshold value above which the fit is more or less linear.
}
\examples{
thselect.mrl(rgp(n = 100))
}
\references{
Langousis, A., A. Mamalakis, M. Puliga and R. Deidda (2016).
\emph{Threshold detection for the generalized Pareto distribution:
Review of representative methods and application to the
NOAA NCDC daily rainfall database}, Water Resources Research, \strong{52}, 2659--2681.
}
