% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validators.R
\name{mgc.validator}
\alias{mgc.validator}
\title{MGC Utility Validator}
\usage{
mgc.validator(
  X,
  Y,
  is.dist.X = FALSE,
  dist.xfm.X = mgc.distance,
  dist.params.X = list(method = "euclidean"),
  dist.return.X = NULL,
  is.dist.Y = FALSE,
  dist.xfm.Y = mgc.distance,
  dist.params.Y = list(method = "euclidean"),
  dist.return.Y = NULL
)
}
\arguments{
\item{X}{is interpreted as:
\describe{
   \item{a \code{[n x d]} data matrix}{X is a data matrix with \code{n} samples in \code{d} dimensions, if flag \code{is.dist=FALSE}.}
   \item{a \code{[n x n]} distance matrix}{X is a distance matrix. Use flag \code{is.dist=TRUE}.}
}}

\item{Y}{\code{[n]} a vector containing the sample ids for our \code{n} samples.}

\item{is.dist.X}{a boolean indicating whether your \code{X} input is a distance matrix or not. Defaults to \code{FALSE}.}

\item{dist.xfm.X}{if \code{is.dist == FALSE}, a distance function to transform \code{X}. If a distance function is passed,
it should accept an \code{[n x d]} matrix of \code{n} samples in \code{d} dimensions and return a \code{[n x n]} distance matrix
as the \code{$D} return argument. See \link[mgc]{mgc.distance} for details.}

\item{dist.params.X}{a list of trailing arguments to pass to the distance function specified in \code{dist.xfm.X}.
Defaults to \code{list(method='euclidean')}.}

\item{dist.return.X}{the return argument for the specified \code{dist.xfm.X} containing the distance matrix. Defaults to \code{FALSE}.
\describe{
    \item{\code{is.null(dist.return)}}{use the return argument directly from \code{dist.xfm} as the distance matrix. Should be a \code{[n x n]} matrix.}
    \item{\code{is.character(dist.return) | is.integer(dist.return)}}{use \code{dist.xfm.X[[dist.return]]} as the distance matrix. Should be a \code{[n x n]} matrix.}
}}

\item{is.dist.Y}{a boolean indicating whether your \code{Y} input is a distance matrix or not. Defaults to \code{FALSE}.}

\item{dist.xfm.Y}{if \code{is.dist == FALSE}, a distance function to transform \code{Y}. If a distance function is passed,
it should accept an \code{[n x d]} matrix of \code{n} samples in \code{d} dimensions and return a \code{[n x n]} distance matrix
as the \code{dist.return.Y} return argument. See \link[mgc]{mgc.distance} for details.}

\item{dist.params.Y}{a list of trailing arguments to pass to the distance function specified in \code{dist.xfm.Y}.
Defaults to \code{list(method='euclidean')}.}

\item{dist.return.Y}{the return argument for the specified \code{dist.xfm.Y} containing the distance matrix. Defaults to \code{FALSE}.
\describe{
    \item{\code{is.null(dist.return)}}{use the return argument directly from \code{dist.xfm.Y(Y)} as the distance matrix. Should be a \code{[n x n]} matrix.}
    \item{\code{is.character(dist.return) | is.integer(dist.return)}}{use \code{dist.xfm.Y(Y)[[dist.return]]} as the distance matrix. Should be a \code{[n x n]} matrix.}
}}
}
\value{
A list containing the following:
\item{\code{D}}{The distance matrix, as a \code{[n x n]} matrix.}
\item{\code{Y}}{the sample ids, as a \code{[n]} vector.}
}
\description{
A script that validates that data inputs are correct, and returns a X distance and Y distance matrix for MGC.
}
\keyword{internal}
