% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_effect.R
\name{plot_effect}
\alias{plot_effect}
\title{plot_effect
plot_effect is a function that plots the effect of a variable X_k with spatially varying coefficient, i.e X_k * Beta_k(u_i,v_i) for comparing the magnitude of effects of between variables.}
\usage{
plot_effect(model,sampling=TRUE,nsample=2000,nsample_max=5000,title='')
}
\arguments{
\item{model}{a model of mgwrsar class with some spatially varying coefficients.}

\item{sampling}{Bolean, if nrow(model@Betav)> nsample_max a sample of size nsample is randomly selected, default TRUE.}

\item{nsample}{integer,  size of the sample if sampling is TRUE, default 2000.}

\item{nsample_max}{integer, size max to engage sampling if sampling is TRUE, default 5000.}

\item{title}{a title for the plot.}
}
\description{
plot_effect
plot_effect is a function that plots the effect of a variable X_k with spatially varying coefficient, i.e X_k * Beta_k(u_i,v_i) for comparing the magnitude of effects of between variables.
}
\examples{
\donttest{
 library(mgwrsar)
 ## loading data example
 data(mydata)
 coords=as.matrix(mydata[,c("x","y")])
 ## Creating a spatial weight matrix (sparce dgCMatrix)
 ## of 8 nearest neighbors with 0 in diagonal
 model_GWR0<-MGWRSAR(formula = 'Y_gwr~X1+X2+X3', data = mydata,coords=coords,
 fixed_vars=NULL,kernels=c('gauss'),H=0.13, Model = 'GWR',control=list(SE=TRUE))
 plot_effect(model_GWR0)
}
}
