% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ic50.R
\name{predict_ic50}
\alias{predict_ic50}
\title{Predict the IC50 for peptides.}
\usage{
predict_ic50(
  mhcnuggets_options,
  peptides,
  peptides_path = create_temp_peptides_path()
)
}
\arguments{
\item{mhcnuggets_options}{options to run MHCnuggets with,
as can be created by \link{create_mhcnuggets_options}.}

\item{peptides}{one of more peptide sequences}

\item{peptides_path}{the path to the peptides}
}
\value{
a tibble with two columns:
(1) \code{peptide}, which holds the peptide sequence, and
(2) \code{ic50}, which holds the predicted IC50
}
\description{
Predict the half maximal inhibitory concentration (aka IC50) (in nM)
for one or more peptides.
Each peptide must be 15 amino acids at
most (use \link{predict_ic50s} to predict the IC50s for longer peptides)
}
\note{
this function uses a temporary file, because MHCnuggets reads its
input from file. This temporary file is deleted after this function
passed successfully.
}
\examples{
if (is_mhcnuggets_installed()) {

  peptides <- c("AIAACAMLLV", "ALVCYIVMPV", "ALEPRKEIDV")
  mhc_1_haplotype <- "HLA-A02:01"

  mhcnuggets_options <- create_mhcnuggets_options(
    mhc = mhc_1_haplotype
  )

  predict_ic50(
    peptides = peptides,
    mhcnuggets_options = mhcnuggets_options
  )
}
}
\author{
Richèl J.C. Bilderbeek
}
