% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milags_functions.R
\name{calc_baranyi_fit_lag}
\alias{calc_baranyi_fit_lag}
\title{calc_baranyi_fit_lag}
\usage{
calc_baranyi_fit_lag(
  data,
  n0,
  init_lag = NULL,
  init_gr_rate = NULL,
  algorithm = "auto",
  max_iter = 100
)
}
\arguments{
\item{data}{a data frame with two required columns names: "time" and "biomass",and one optional column: "curve_id"
This is data from may come from multiple growth curves}

\item{n0}{a data frame describing initial biomass for each of the curves, i.e. it has two obligatory columns: "curve_id", "N0"}

\item{init_lag}{initial value for the lag parameter, defaults to NULL in which case it will be approximated based on the data}

\item{init_gr_rate}{initial value for the growth rate, defaults to NULL in which case it will be approximated based on the data}

\item{algorithm}{eg. "auto", "Levenberg-Marquardt", "port", defaults to "auto"}

\item{max_iter}{Maximum number of iterations, defaults to 100}
}
\value{
growth curve data with additional columns  ('lag', and predicted biomass 'predicted')
}
\description{
Calculates lag based on fitting baranyi model to data
}
