% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milags_functions.R
\name{choose_lag_fit_algorithm_logistic}
\alias{choose_lag_fit_algorithm_logistic}
\title{choose_lag_fit_algorithm_logistic}
\usage{
choose_lag_fit_algorithm_logistic(
  gr_curve,
  n0,
  init_gr_rate = init_gr_rate,
  init_K = init_K,
  init_lag = init_lag,
  max_iter = 100,
  lower_bound = c(0, 0, 0)
)
}
\arguments{
\item{gr_curve}{data from one specific growth curve with the following columns: LOG10N, t}

\item{n0}{the initial biomass}

\item{init_gr_rate}{initial value for the growth rate}

\item{init_K}{initial value for the saturation parameter K}

\item{init_lag}{initial value for the lag parameter}

\item{max_iter}{max. number of iterations; defaults to 100}

\item{lower_bound}{lower bound for the bounded nls optimization; defaults to 0}
}
\value{
the best nls fitting object with parameters fitted to logistic model (lowest Res.Sum Sq provided that all coefficients are nonnegative)
}
\description{
Runs nlsLM/nls algorithms with three different parameter setups to fit the best Logistic model parameters to our data and chooses the best model
}
