% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_scalar_RR.R
\name{pool_scalar_RR}
\alias{pool_scalar_RR}
\title{Rubin's Rules for scalar estimates}
\usage{
pool_scalar_RR(
  est,
  se,
  logit_trans = FALSE,
  conf.level = 0.95,
  statistic = FALSE,
  dfcom = NULL,
  df_small = TRUE,
  approxim = "tdistr"
)
}
\arguments{
\item{est}{a numerical vector of parameter estimates.}

\item{se}{a numerical vector of standard error estimates.}

\item{logit_trans}{If TRUE logit transformation of parameter values
is applied before pooling, if FALSE (default), pooling is done
on the original parameter scale.}

\item{conf.level}{Confidence level of the confidence intervals.}

\item{statistic}{if TRUE the test statistic and confidence interval are
provided, if FALSE (default) these are not shown.}

\item{dfcom}{The complete data analysis degrees of freedom.}

\item{df_small}{if TRUE (default) the (Barnard & Rubin) small sample
correction for the degrees of freedom is applied, if FALSE the old
number of degrees of freedom is calculated.}

\item{approxim}{if "tdistr" a t-distribution is used (default), if "zdistr"
a z-distribution is used to derive a p-value according to the test statistic.}
}
\value{
A list object from which the following objects are extracted:
\itemize{
\item  \code{pool_est} the pooled parameter value.
\item  \code{pool_se} the pooled standard error value.
\item  \code{t} quantile of the t-distribution (to calculate
confidence intervals).
\item  \code{r} the relative increase in variance due to missing data.
\item  \code{dfcom} complete data degrees of freedom.
\item  \code{v_adj} adjusted degrees of freedom (according to
Barnard and Rubin 1999)
}
}
\description{
\code{pool_scalar_RR} Applies Rubin's pooling Rules for scalar
estimates
}
\details{
The t-value is the quantile value of the t-distribution that can
be used to calculate confidence intervals according to
\eqn{est_{pooled} +/- t_{1-\alpha/2} * se_{pooled}}. When statistic is
TRUE the test statistic is calculated as
\eqn{statistic = est{pooled}/se{pooled}}. The p-value is than
derived using the t-distribution and adjusted degrees of freedom.
}
\examples{
est <- c(0.4, 0.6, 0.8)
se <- c(0.02, 0.05, 0.03)
res <- pool_scalar_RR(est, se, dfcom=500)
res

}
\author{
Martijn Heymans, 2021
}
