% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtract_T0.R
\name{subtract_T0}
\alias{subtract_T0}
\title{Subtract timepoint T0 and remove from data}
\usage{
subtract_T0(
  input_data,
  grouping = c("Group", "Experiment", "Position"),
  value = "Value",
  timepoint = "Timepoint",
  validity = "Validity"
)
}
\arguments{
\item{input_data}{A data frame containing columns preferably named as 'Position', 'Value', 
'Experiment','Validity', and 'Timepoint'.}

\item{grouping}{A character vector specifying the columns to use for grouping.
Defaults to c("Experiment", "Position").}

\item{value}{The column containing the values to be modified. Defaults to "Value".}

\item{timepoint}{The column containing the timepoint information. Defaults to "Timepoint".}

\item{validity}{The column containing validity information. Defaults to "Validity".}
}
\value{
A modified data frame with timepoint T0 subtracted and removed.
}
\description{
This function subtracts the values at timepoint T0 from all other timepoints
and removes it from the data.
}
\details{
This function modifies the input data frame by subtracting the value at 
T0 timepoint from all other timepoints for each plate (i.e. experiment). It then removes the rows with 
this timepoint from the data frame.
}
