% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnaManipulate.R
\name{translate}
\alias{translate}
\title{Translation according to the standard genetic code}
\usage{
translate(nuc.sequences, M.start = TRUE, no.stop = TRUE, trans.tab = 11)
}
\arguments{
\item{nuc.sequences}{Character vector containing the nucleotide sequences.}

\item{M.start}{A logical indicating if the amino acid sequence should start with M regardless of start codon.}

\item{no.stop}{A logical indicating if terminal stops (*) should be eliminated from the translated sequence}

\item{trans.tab}{Translation table, either 11 or 4}
}
\value{
A character vector of translated sequences.
}
\description{
The translation from DNA(RNA) to amino acid sequence according to the standard genetic code.
}
\details{
Codons are by default translated according to translation table 11, i.e. the possible start codons
are ATG, GTG or TTG and stop codons are TAA, TGA and TAG.  The only alternative implemented here is
translation table 4, which is used by some bacteria (e.g. Mycoplasma, Mesoplasma). If \code{trans.tab} is 4,
the stop codon TGA istranslated to W (Tryptophan).
}
\examples{
fa.file <- file.path(file.path(path.package("microseq"),"extdata"),"small.ffn")
fa <- readFasta(fa.file)
translate(fa$Sequence)

# Or, make use of dplyr to manipulate tables
readFasta(fa.file) \%>\%
  mutate(Protein = translate(Sequence)) -> fa.tbl

}
\author{
Lars Snipen and Kristian Hovde Liland.
}
