% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nb_non_zero.R
\name{nb_non_zero}
\alias{nb_non_zero}
\title{Handle negative native born populations}
\usage{
nb_non_zero(m, verbose = FALSE)
}
\arguments{
\item{m}{Matrix of migrant stock totals. Rows in the matrix correspond to place of birth and columns to place of residence at time \emph{t}}

\item{verbose}{Logical value to indicate the print the parameter estimates at each iteration. By default \code{FALSE}.}
}
\value{
A matrix which scales the elements in columns (places of residence) with a negative population to match the overall population (column total). Negative values will be replaced with zero. Positive values will be scaled down to ensure the column total matches the original \code{m}.
}
\description{
This function is predominantly intended to be used within the ffs routines in the migest package. Adjustment to ensure positive population counts in all elements of stock matrix. On rare occasions when working with international stock data the foreign born population can exceed the total population due to conflicting data sources.
}
\examples{
\donttest{
## cant have examples if function not in namespace - i.e. without export 
## so comment all out for own use
# dn <- LETTERS[1:4]
# P <- matrix(data = c(1000, 100, 10, 0, 55, 555, 50, 5, 80, 40, 800, 40, 20, 25, 20, 200),
#             nrow = 4, ncol = 4, dimnames = list(pob = dn, por = dn), byrow = TRUE)
# # display with row and col totals
# addmargins(A = P)
# 
# # no change
# y <- nb_non_zero(m = P)
# addmargins(A = y)
# 
# # adjust a native born population to negative
# P[4, 4] <- -20
# # display with row and col totals
# addmargins(A = P)
# 
# y <- nb_non_zero(m = P)
# addmargins(A = y)
}
}
\seealso{
\code{\link{ffs_demo}}
}
\author{
Guy J. Abel
}
