% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miic.plot.R
\name{plot.miic}
\alias{plot.miic}
\title{Basic plot function of a miic network inference result}
\usage{
\method{plot}{miic}(x, method = "igraph", pcor_palette = NULL, ...)
}
\arguments{
\item{x}{[a miic object, required]

The object returned by \code{\link{miic}} execution.}

\item{method}{[a string, optional, default value "igraph"]

The plotting method, currently only "igraph" is supported.}

\item{pcor_palette}{[a color palette, optional, default value
grDevices::colorRampPalette(c("blue", "darkgrey", "red")]

Used to represent the partial correlations (the color of the edges).
The palette must be able to handle 201 shades to cover the correlation range
from -100 to +100.}

\item{\dots}{Additional plotting parameters. See the corresponding plot
function for the complete list.

For igraph, see \code{\link[igraph]{igraph.plotting}}.}
}
\description{
This function calls \code{\link{export}} to build a
plottable object from the result returned by \code{\link{miic}} and plot it.
}
\details{
See the documentation of \code{\link{export}} for further
details.
}
\seealso{
\code{\link{export}} for graphical exports,
\code{\link[igraph]{igraph.plotting}}
}
