% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_feats.R
\name{get_groups_from_clusters}
\alias{get_groups_from_clusters}
\title{Assign features to groups}
\usage{
get_groups_from_clusters(cluster_ids)
}
\arguments{
\item{cluster_ids}{named vector created by \code{cluster_corr_mat()}.
Each element is a cluster and the name is a feature in that cluster.}
}
\value{
a vector where each element is a group of correlated features
separated by pipes (\code{|})
}
\description{
Assign features to groups
}
\examples{
\dontrun{
corr_mat <- matrix(
  data = c(1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1),
  nrow = 4,
  dimnames = list(
    c("a", "b", "c", "d"),
    c("a", "b", "c", "d")
  )
)
corr_mat
get_groups_from_clusters(cluster_corr_mat(corr_mat))
}
}
\author{
Kelly Sovacool, \email{sovacool@umich.edu}
}
\keyword{internal}
