% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesianMixtureSBM.R
\name{BayesianMixture_SBM_model}
\alias{BayesianMixture_SBM_model}
\title{mimiSBM model for fixed K and Q}
\usage{
BayesianMixture_SBM_model(
  A,
  K,
  Q,
  beta_0 = rep(1/2, K),
  theta_0 = rep(1/2, Q),
  eta_0 = array(rep(1/2, K * K * Q), c(K, K, Q)),
  xi_0 = array(rep(1/2, K * K * Q), c(K, K, Q)),
  tol = 0.001,
  iter_max = 10,
  n_init = 1,
  alternate = TRUE,
  Verbose = TRUE,
  eps_conv = 1e-04,
  type_init = "SBM",
  nbCores = 2
)
}
\arguments{
\item{A}{an array of dim=c(N,N,V)}

\item{K}{number of clusters}

\item{Q}{number of components}

\item{beta_0}{hyperparameters for beta}

\item{theta_0}{hyperparameters for theta}

\item{eta_0}{hyperparameters for eta}

\item{xi_0}{hyperparameters for xi}

\item{tol}{convergence parameter on ELBO}

\item{iter_max}{maximal number of iteration of mimiSBM}

\item{n_init}{number of initialization of the mimi algorithm.}

\item{alternate}{boolean indicated if we put an M-step after each part of the E-step, after u optimization and after tau optimization. If not, we optimize u and tau and after the M-step is made.}

\item{Verbose}{boolean for information on model fitting}

\item{eps_conv}{parameter of convergence for tau.}

\item{type_init}{select the type of initialization type_init=c("SBM","Kmeans","random")}

\item{nbCores}{the number of cores used to parallelize the calculations

See the vignette for more details.}
}
\value{
model with estimation of coefficients.
}
\description{
mimiSBM model for fixed K and Q
}
