% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play_minesweeper.R
\name{play_minesweeper}
\alias{play_minesweeper}
\title{Start a Minesweeper Game}
\usage{
play_minesweeper(
  difficulty = c("expert", "intermediate", "beginner"),
  nrow = NULL,
  ncol = NULL,
  mine_count = NULL,
  mine_density = NULL,
  os_type = c("guess", "unix", "windows")
)
}
\arguments{
\item{difficulty}{establishes default dimensions and mine count}

\item{nrow, ncol}{dimensions of the minesweeper board}

\item{mine_count}{number of mines to sweep}

\item{mine_density}{proportion of cells that conceal a mine}

\item{os_type}{used to interpret \code{button} argument of event handlers}
}
\value{
Object of class "minesweeper_recording" to pass to
\code{\link[=replay_minesweeper]{replay_minesweeper()}} or \code{\link[=save_minesweeper_gif]{save_minesweeper_gif()}}, invisibly.
}
\description{
Play minesweeper interactively in the current graphics device.
}
\details{
Expert difficulty is 16x30 with 99 mines, intermediate 16x16 with 40 mines,
and beginner 9x9 with 10 mines.

The current graphics device must support event handling
(see \code{\link[grDevices:getGraphicsEvent]{grDevices::getGraphicsEvent()}}). If \code{onIdle} is not supported,
the timer will only update on mouse events.
}
\section{Controls}{

\itemize{
\item \strong{Left click} an empty square to reveal it.
\item \strong{Right click} an empty square to flag it.
\item \strong{Middle click} a number to reveal its adjacent squares.
\item Press \strong{r} to reset the board.
\item Press \strong{q} to quit.
}
}

\examples{
\dontshow{if (.Platform$OS.type == "unix" && interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
x11() # Unix-specific example
recording <- play_minesweeper()
dev.off()
\dontshow{\}) # examplesIf}
}
