% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{lnm}
\alias{lnm}
\title{Fit a logistic normal multinomial model using R's formula interface.}
\usage{
lnm(formula, data, sigma_b = 2, l1 = 10, l2 = 10, ...)
}
\arguments{
\item{formula}{A formula specifying the model structure.}

\item{data}{A data frame containing the variables specified in the formula.}

\item{sigma_b}{The prior standard deviation of the beta coefficients in the
LNM model. See the 'Stan' code definition in inst/stan/lnm.stan for the
full model specification.}

\item{l1}{The first inverse gamma hyperprior parameter for sigmas_mu.}

\item{l2}{The first inverse gamma hyperprior parameter for sigmas_mu.}

\item{...}{Additional arguments to be passed to the underlying vb() call from
'rstan'.}
}
\value{
An object of class "lnm" representing the fitted LNM model.
}
\description{
This function fits a logistic normal multinomial (LNM) model to the data
using R's formula interface. The LNM model is a generalization of the
multinomial logistic regression model, allowing for correlated responses
within each category of the response variable. It can be used to learn the
relationship between experimental/environmental factors and community
composition. It is a statistical model that estimates the probabilities of
different outcomes in a multinomial distribution, given a set of covariates.
The LNM model assumes that a log-ratio of the outcome probabilities follow a
multivariate normal distribution. By fitting the LNM model to observed data,
we can infer the effects of the covariates on the outcome compositions.
}
\examples{
example_data <- lnm_data(N = 50, K = 10)
xy <- dplyr::bind_cols(example_data[c("X", "y")])
fit <- lnm(
    starts_with("y") ~ starts_with("x"), xy, 
    iter = 25, output_samples = 25
)
}
