% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{pdf_translate}
\alias{pdf_translate}
\title{Modify global transformation matrix with additional translation}
\usage{
pdf_translate(doc, x, y)
}
\arguments{
\item{doc}{A \code{pdf_doc} object created by \code{\link{create_pdf}()}}

\item{x, y}{translation}
}
\value{
\code{pdf_doc}
}
\description{
Global transformations are cumulative, and these is no operation to reset
the global transformation.
For local transformations use the \code{tf} argument for individual objects.
}
\examples{
doc <- create_pdf() |>
   pdf_translate(x = 10, y = 10)
}
\seealso{
Other transform functions: 
\code{\link{pdf_rotate}()},
\code{\link{pdf_scale}()},
\code{\link{tf_rotate}()},
\code{\link{tf_scale}()},
\code{\link{tf_translate}()}

Other global transform functions: 
\code{\link{pdf_rotate}()},
\code{\link{pdf_scale}()}
}
\concept{global transform functions}
\concept{transform functions}
