\name{mvt.mcmc}
\alias{mvt.mcmc}
\title{Estimate Parameters of a Multivariate t Distribution Using the MCMC 
}
\description{
  Use the MCMC to obtain estimate of parameters of a multivariate t distribution.
}
\usage{
  mvt.mcmc(X, prior.lower.v, prior.upper.v,
           prior.Mu0=rep(0, ncol(X)), prior.Sigma0=diag(10000, ncol(X)),
           prior.p=ncol(X), prior.V=diag(1, ncol(X)),
           initial.v=NULL, initial.Sigma=NULL,
           nmcmc=10000, nburn=nmcmc/10, nthin=1, seed=1)
}
\arguments{
  \item{X}{a matrix of observations with one subject per row.}
  \item{prior.lower.v}{lower bound of degrees of freedom (df).}
  \item{prior.upper.v}{upper bound of df.}
  \item{prior.Mu0}{mean vector of multivariate normal prior of the
	location. The default value is 0.}
  \item{prior.Sigma0}{variance matrix of multivariate normal prior of
	the location. The default value is a diagonal matrix with diagonal
	entries equal to 10000.}
  \item{prior.p}{the df of wishart prior of inverse of the scale matrix. The
	default value is dimensions of observation.}
  \item{prior.V}{the scale matrix of wishart prior of inverse of the scale
	matrix.	The	default value is identity matrix.}
  \item{initial.v}{the initial value of the df. The default is
	\code{NULL}. For the default, the value will be generated by using
	the ECME Algorithm.}
  \item{initial.Sigma}{the initial value of the scale matrix. The default is
	\code{NULL}. For the default, the value will be generated by using
	the ECME Algorithm.}
	  \item{nmcmc}{number of iterations. The default value is 10000.}
  \item{nburn}{number of burn-in. The default value is \code{nmcmc}/10.}
  \item{nthin}{output every \code{nthin}-th sample. The default value is 1 (no thinning).}
  \item{seed}{random seed. The default value is 1. Note that \code{seed} can be an integer from 1 to 14. 
        The internal state of the OpenBUGS random number generator can be set to one of 14 predefined 
        states.}
}
\value{
  \item{Mu.save}{a matrix of locations of the distribution, one row per iteration.}
  \item{Sigma.save}{a three dimensional array of scale matrix of the
	distribution. Sigma.save[,,i] is the result from the ith iteration.}
  \item{v.save}{a vector of df of the distribution, one component per iteration.}
}
\details{
  To generate samples from the full conditional distribution of
  df, the slice sampling was used and the code was adapted from
  \url{http://www.cs.toronto.edu/~radford/ftp/slice-R-prog}.
}
\seealso{
  \code{\link[miscF]{mvt.ecme}}
}
\examples{
\dontrun{
  mu1 <- mu2 <- sigma12 <- sigma22 <- 100
  rho12 <- 0.9
  Sigma <- matrix(c(sigma12, rho12*sqrt(sigma12*sigma22),
                    rho12*sqrt(sigma12*sigma22), sigma22),
                  nrow=2)
  k <- 8
  N <- 100
  X <- rmvt(N, sigma=Sigma, df=k, delta=c(mu1, mu2))

  result <- mvt.mcmc(X, 4, 25)
  colMeans(result$Mu.save)
  apply(result$Sigma.save, c(1,2), mean)
  mean(result$v.save)
}
}
\keyword{multivariate}



