% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-modify.R
\name{gtrack.smooth}
\alias{gtrack.smooth}
\title{Creates a new track from smoothed values of track expression}
\usage{
gtrack.smooth(
  track = NULL,
  description = NULL,
  expr = NULL,
  winsize = NULL,
  weight_thr = 0,
  smooth_nans = FALSE,
  alg = "LINEAR_RAMP",
  iterator = NULL
)
}
\arguments{
\item{track}{track name}

\item{description}{a character string description}

\item{expr}{track expression}

\item{winsize}{size of smoothing window}

\item{weight_thr}{smoothing weight threshold}

\item{smooth_nans}{if 'FALSE' track value is always set to 'NaN' if central
window value is 'NaN', otherwise it is calculated from the rest of non 'NaN'
values}

\item{alg}{smoothing algorithm - "MEAN" or "LINEAR_RAMP"}

\item{iterator}{track expression iterator of 'Fixed bin' type}
}
\value{
None.
}
\description{
Creates a new track from smoothed values of track expression.
}
\details{
This function creates a new 'Dense' track named 'track'. The values of the
track are results of smoothing the values of 'expr'.

Each track value at coordinate 'C' is determined by smoothing non 'NaN'
values of 'expr' over the window around 'C'. The window size is controlled
by 'winsize' and is given in coordinate units (not in number of bins),
defining the total regions to be considered when smoothing (on both sides of
the central point). Two different algorithms can be used for smoothing:

"MEAN" - an arithmetic average.

"LINEAR_RAMP" - a weighted arithmetic average, where the weights linearly
decrease as the distance from the center of the window increases.

'weight_thr' determines the function behavior when some of the values in the
window are missing or 'NaN' (missing values may occur at the edges of each
chromosome when the window covers an area beyond chromosome boundaries).
'weight_thr' sets the weight sum threshold below which smoothing algorithm
returns 'NaN' rather than a smoothing value based on non 'NaN' values in the
window.

'smooth_nans' controls what would be the smoothed value if the central value
in the window is 'NaN'. If 'smooth_nans' is 'FALSE' then the smoothed value
is set to 'NaN' regardless of 'weight_thr' parameter. Otherwise it is
calculated normally.

'description' is added as a track attribute.

Iterator policy must be of "fixed bin" type.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gtrack.smooth("smoothed_track", "Test track", "dense_track", 500)
gextract("dense_track", "smoothed_track", gintervals(1, 0, 1000))
gtrack.rm("smoothed_track", force = TRUE)

}
\seealso{
\code{\link{gtrack.create}}, \code{\link{gtrack.2d.create}},
\code{\link{gtrack.create_sparse}}, \code{\link{gtrack.modify}},
\code{\link{gtrack.rm}}, \code{\link{gtrack.info}},
\code{\link{gdir.create}}
}
\keyword{~smooth}
\keyword{~track}
