% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_conditioned_prop.R
\name{compute_conditioned_prop}
\alias{compute_conditioned_prop}
\title{Compute Conditioned Proportions for Pigmentation Traits}
\usage{
compute_conditioned_prop(data, h, s, y, eh, es, ey)
}
\arguments{
\item{data}{A data.frame with columns \code{hair_colour}, \code{skin_colour},
and \code{eye_colour}, typically output from \code{\link{sim_reference_pop}}.}

\item{h}{Integer (1-5). Missing person's hair color category.}

\item{s}{Integer (1-5). Missing person's skin color category.}

\item{y}{Integer (1-5). Missing person's eye color category.}

\item{eh}{Numeric (0-1). Error rate for observing hair color.}

\item{es}{Numeric (0-1). Error rate for observing skin color.}

\item{ey}{Numeric (0-1). Error rate for observing eye color.}
}
\value{
A data.frame with the original trait columns plus:
\itemize{
\item \code{numerators}: Conditioned probability for each combination,
normalized to sum to 1
}
Only unique combinations are returned.
}
\description{
Calculates the conditioned proportions (numerator probabilities) for
pigmentation trait combinations given the missing person's characteristics.
These proportions represent P(observed traits | H1), accounting for
observation errors.
}
\details{
The function calculates the probability of observing each trait combination
given the MP's true characteristics and the error rates. Higher probabilities
are assigned to combinations matching the MP's traits, while combinations
with mismatches have probabilities proportional to the error rates.
}
\examples{
# Generate reference population
pop_data <- sim_reference_pop(n = 500, seed = 123)

# Compute conditioned proportions for MP with traits (1,1,1)
cond_prop <- compute_conditioned_prop(
  pop_data,
  h = 1, s = 1, y = 1,
  eh = 0.01, es = 0.01, ey = 0.01
)
head(cond_prop)
}
\references{
Marsico FL, et al. (2023). "Likelihood ratios for non-genetic evidence
in missing person cases." \emph{Forensic Science International: Genetics},
66, 102891. \doi{10.1016/j.fsigen.2023.102891}
}
\seealso{
\code{\link{sim_reference_pop}} for generating the input data,
\code{\link{compute_reference_prop}} for reference proportions,
\code{\link{lr_compute_pigmentation}} for computing LRs.
}
