% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_rpart.R
\name{mlRpart}
\alias{mlRpart}
\alias{ml_rpart}
\alias{mlRpart.formula}
\alias{mlRpart.default}
\alias{predict.mlRpart}
\title{Supervised classification and regression using recursive partitioning}
\usage{
mlRpart(train, ...)

ml_rpart(train, ...)

\method{mlRpart}{formula}(formula, data, ..., subset, na.action)

\method{mlRpart}{default}(train, response, ..., .args. = NULL)

\method{predict}{mlRpart}(
  object,
  newdata,
  type = c("class", "membership", "both"),
  method = c("direct", "cv"),
  ...
)
}
\arguments{
\item{train}{a matrix or data frame with predictors.}

\item{...}{further arguments passed to \code{\link[rpart:rpart]{rpart::rpart()}} or its \code{\link[=predict]{predict()}}
method (see the corresponding help page.}

\item{formula}{a formula with left term being the factor variable to predict
(for supervised classification), a vector of numbers (for regression) and the
right term with the list of independent, predictive variables, separated with
a plus sign. If the data frame provided contains only the dependent and
independent variables, one can use the \code{class ~ .} short version (that one is
strongly encouraged). Variables with minus sign are eliminated. Calculations
on variables are possible according to usual formula convention (possibly
protected by using \code{I()}).}

\item{data}{a data.frame to use as a training set.}

\item{subset}{index vector with the cases to define the training set in use
(this argument must be named, if provided).}

\item{na.action}{function to specify the action to be taken if \code{NA}s are
found. For \code{\link[=ml_rpart]{ml_rpart()}} \code{na.fail} is used by default. The calculation is
stopped if there is any \code{NA} in the data. Another option is \code{na.omit},
where cases with missing values on any required variable are dropped (this
argument must be named, if provided). For the \code{predict()} method, the
default, and most suitable option, is \code{na.exclude}. In that case, rows with
\code{NA}s in \verb{newdata=} are excluded from prediction, but reinjected in the
final results so that the number of items is still the same (and in the
same order as \verb{newdata=}).}

\item{response}{a vector of factor (classification) or numeric (regression).}

\item{.args.}{used internally, do not provide anything here.}

\item{object}{an \strong{mlRpart} object}

\item{newdata}{a new dataset with same conformation as the training set (same
variables, except may by the class for classification or dependent variable
for regression). Usually a test set, or a new dataset to be predicted.}

\item{type}{the type of prediction to return. \code{"class"} by default, the
predicted classes. Other options are \code{"membership"} the membership (number
between 0 and 1) to the different classes, or \code{"both"} to return classes
and memberships,}

\item{method}{\code{"direct"} (default) or \code{"cv"}. \code{"direct"} predicts new cases in
\verb{newdata=} if this argument is provided, or the cases in the training set
if not. Take care that not providing \verb{newdata=} means that you just
calculate the \strong{self-consistency} of the classifier but cannot use the
metrics derived from these results for the assessment of its performances.
Either use a different data set in \verb{newdata=} or use the alternate
cross-validation ("cv") technique. If you specify \code{method = "cv"} then
\code{\link[=cvpredict]{cvpredict()}} is used and you cannot provide \verb{newdata=} in that case.}
}
\value{
\code{\link[=ml_rpart]{ml_rpart()}}/\code{\link[=mlRpart]{mlRpart()}} creates an \strong{mlRpart}, \strong{mlearning} object
containing the classifier and a lot of additional metadata used by the
functions and methods you can apply to it like \code{\link[=predict]{predict()}} or
\code{\link[=cvpredict]{cvpredict()}}. In case you want to program new functions or extract
specific components, inspect the "unclassed" object using \code{\link[=unclass]{unclass()}}.
}
\description{
Unified (formula-based) interface version of the recursive partitioning
algorithm as implemented in \code{\link[rpart:rpart]{rpart::rpart()}}.
}
\examples{
# Prepare data: split into training set (2/3) and test set (1/3)
data("iris", package = "datasets")
train <- c(1:34, 51:83, 101:133)
iris_train <- iris[train, ]
iris_test <- iris[-train, ]
# One case with missing data in train set, and another case in test set
iris_train[1, 1] <- NA
iris_test[25, 2] <- NA

iris_rpart <- ml_rpart(data = iris_train, Species ~ .)
summary(iris_rpart)
# Plot the decision tree for this classifier
plot(iris_rpart, margin = 0.03, uniform = TRUE)
text(iris_rpart, use.n = FALSE)
# Predictions
predict(iris_rpart) # Default type is class
predict(iris_rpart, type = "membership")
predict(iris_rpart, type = "both")
# Self-consistency, do not use for assessing classifier performances!
confusion(iris_rpart)
# Cross-validation prediction is a good choice when there is no test set
predict(iris_rpart, method = "cv")  # Idem: cvpredict(res)
confusion(iris_rpart, method = "cv")
# Evaluation of performances using a separate test set
confusion(predict(iris_rpart, newdata = iris_test), iris_test$Species)
}
\seealso{
\code{\link[=mlearning]{mlearning()}}, \code{\link[=cvpredict]{cvpredict()}}, \code{\link[=confusion]{confusion()}}, also \code{\link[rpart:rpart]{rpart::rpart()}}
that actually does the classification.
}
