#' @importFrom utils bibentry
# nolint start
bibentries = c(
  ruspini_1970 = bibentry("article",
    doi = "10.1016/S0020-0255(70)80056-1",
    year = "1970",
    volume = "2",
    number = "3",
    pages = "319-350",
    author = "Enrique H. Ruspini",
    title = "Numerical methods for fuzzy clustering",
    journal = "Information Sciences"
  ),
  ester1996density = bibentry("inproceedings",
    title = "A density-based algorithm for discovering clusters in large spatial databases with noise",
    author = "Ester, Martin and Kriegel, Hans-Peter and Sander, J\u00F6rg and Xu, Xiaowei and others",
    booktitle = "kdd",
    volume = "96",
    number = "34",
    pages = "226--231",
    year = "1996"
  ),
  campello2013density = bibentry("inproceedings",
    title = "Density-based clustering based on hierarchical density estimates",
    author = "Campello, Ricardo JGB and Moulavi, Davoud and Sander, J\u00F6rg",
    booktitle = "Pacific-Asia conference on knowledge discovery and data mining",
    pages = "160--172",
    year = "2013",
    organization = "Springer"
  ),
  ankerst1999optics = bibentry("article",
    title = "OPTICS: Ordering points to identify the clustering structure",
    author = "Ankerst, Mihael and Breunig, Markus M and Kriegel, Hans-Peter and Sander, J\u00F6rg",
    journal = "ACM Sigmod record",
    volume = "28",
    number = "2",
    pages = "49--60",
    year = "1999",
    publisher = "ACM New York, NY, USA"
  ),
  frey2007clustering = bibentry("article",
    title = "Clustering by passing messages between data points",
    author = "Frey, Brendan J and Dueck, Delbert",
    journal = "science",
    volume = "315",
    number = "5814",
    pages = "972--976",
    year = "2007",
    publisher = "American Association for the Advancement of Science"
  ),
  kaufman2009finding = bibentry("book",
    title = "Finding groups in data: an introduction to cluster analysis",
    author = "Kaufman, Leonard and Rousseeuw, Peter J",
    year = "2009",
    publisher = "John Wiley & Sons"
  ),
  bezdek2013pattern = bibentry("book",
    title = "Pattern recognition with fuzzy objective function algorithms",
    author = "Bezdek, James C",
    year = "2013",
    publisher = "Springer Science & Business Media"
  ),
  fisher1987knowledge = bibentry("article",
    title = "Knowledge acquisition via incremental conceptual clustering",
    author = "Fisher, Douglas H",
    journal = "Machine learning",
    volume = "2",
    pages = "139--172",
    year = "1987",
    publisher = "Springer"
  ),
  gennari1989models = bibentry("article",
    title = "Models of incremental concept formation",
    author = "Gennari, John H and Langley, Pat and Fisher, Doug",
    journal = "Artificial intelligence",
    volume = "40",
    number = "1-3",
    pages = "11--61",
    year = "1989",
    publisher = "Elsevier"
  ),
  hochbaum1985best = bibentry("article",
    title = "A best possible heuristic for the k-center problem",
    author = "Hochbaum, Dorit S and Shmoys, David B",
    journal = "Mathematics of operations research",
    volume = "10",
    number = "2",
    pages = "180--184",
    year = "1985",
    publisher = "INFORMS"
  ),
  dhillon2004unified = bibentry("book",
    title = "A unified view of kernel k-means, spectral clustering and graph cuts",
    author = "Dhillon, Inderjit S and Guan, Yuqiang and Kulis, Brian",
    year = "2004",
    publisher = "Citeseer"
  ),
  lloyd1982least = bibentry("article",
    title = "Least squares quantization in PCM",
    author = "Lloyd, Stuart P",
    journal = "IEEE Transactions on Information Theory",
    volume = "28",
    number = "2",
    pages = "129--137",
    year = "1982",
    publisher = "IEEE"
  ),
  forgy1965cluster = bibentry("article",
    title = "Cluster analysis of multivariate data: efficiency versus interpretability of classifications",
    author = "Forgy, Edward W",
    journal = "Biometrics",
    volume = "21",
    pages = "768--769",
    year = "1965"
  ),
  macqueen1967some = bibentry("inproceedings",
    title = "Some methods for classification and analysis of multivariate observations",
    author = "MacQueen, James",
    booktitle = "Proceedings of the Fifth Berkeley Symposium on Mathematical Statistics and Probability",
    volume = "1",
    pages = "281--297",
    year = "1967",
    address = "Berkeley, CA",
    publisher = "University of California Press"
  ),
  hartigan1979algorithm = bibentry("article",
    title = "Algorithm AS 136: A K-means clustering algorithm",
    author = "Hartigan, John A and Wong, Manchek A",
    journal = "Journal of the Royal Statistical Society. Series C (Applied Statistics)",
    volume = "28",
    number = "1",
    pages = "100--108",
    year = "1979",
    doi = "10.2307/2346830"
  ),
  fraley2002model = bibentry("article",
    title = "Model-based clustering, discriminant analysis, and density estimation",
    author = "Fraley, Chris and Raftery, Adrian E",
    journal = "Journal of the American statistical Association",
    volume = "97",
    number = "458",
    pages = "611--631",
    year = "2002",
    publisher = "Taylor & Francis"
  ),
  cheng1995mean = bibentry("article",
    title = "Mean shift, mode seeking, and clustering",
    author = "Cheng, Yizong",
    journal = "IEEE transactions on pattern analysis and machine intelligence",
    volume = "17",
    number = "8",
    pages = "790--799",
    year = "1995",
    publisher = "IEEE"
  ),
  hahsler2019dbscan = bibentry("article",
    title = "{dbscan}: Fast Density-Based Clustering with {R}",
    author = "Michael Hahsler and Matthew Piekenbrock and Derek Doran",
    journal = "Journal of Statistical Software",
    year = "2019",
    volume = "91",
    number = "1",
    pages = "1--30",
    doi = "10.18637/jss.v091.i01",
  ),
  sculley2010web = bibentry("inproceedings",
    title = "Web-scale k-means clustering",
    author = "Sculley, David",
    booktitle = "Proceedings of the 19th international conference on World wide web",
    pages = "1177--1178",
    year = "2010"
  ),
  reynolds2006clustering = bibentry("article",
    title = "Clustering rules: a comparison of partitioning and hierarchical clustering algorithms",
    author = "Reynolds, Alan P and Richards, Graeme and de la Iglesia, Beatriz and Rayward-Smith, Victor J",
    journal = "Journal of Mathematical Modelling and Algorithms",
    volume = "5",
    pages = "475--504",
    year = "2006",
    publisher = "Springer"
  ),
  schubert2019faster = bibentry("inproceedings",
    title = "Faster k-medoids clustering: improving the PAM, CLARA, and CLARANS algorithms",
    author = "Schubert, Erich and Rousseeuw, Peter J",
    booktitle = "Similarity Search and Applications: 12th International Conference, SISAP 2019, Newark, NJ, USA, October 2--4, 2019, Proceedings 12",
    pages = "171--187",
    year = "2019",
    organization = "Springer"
  ),
  pelleg2000x = bibentry("inproceedings",
    title = "X-means: Extending k-means with efficient estimation of the number of clusters.",
    author = "Pelleg, Dan and Moore, Andrew W and others",
    booktitle = "Icml",
    volume = "1",
    pages = "727--734",
    year = "2000"
  ),
  bodenhofer2011apcluster = bibentry("article",
    title = "{APCluster}: an {R} package for affinity propagation clustering",
    author = "Bodenhofer, Ulrich and Kothmeier, Andreas and Hochreiter, Sepp",
    journal = "Bioinformatics",
    volume = "27",
    number = "17",
    pages = "2463--2464",
    year = "2011",
    publisher = "Oxford University Press"
  ),
  dimitriadou2008misc = bibentry("article",
    title = "Misc functions of the Department of Statistics (e1071), TU Wien",
    author = "Dimitriadou, Evgenia and Hornik, Kurt and Leisch, Friedrich and Meyer, David and Weingessel, Andreas",
    journal = "R package",
    volume = "1",
    pages = "5--24",
    year = "2008",
    publisher = "Citeseer"
  ),
  karatzoglou2004kernlab = bibentry("article",
    title = "kernlab-an S4 package for kernel methods in R",
    author = "Karatzoglou, Alexandros and Smola, Alexandros and Hornik, Kurt and Zeileis, Achim",
    journal = "Journal of statistical software",
    volume = "11",
    pages = "1--20",
    year = "2004"
  ),
  scrucca2016mclust = bibentry("article",
    title = "mclust 5: clustering, classification and density estimation using Gaussian finite mixture models",
    author = "Scrucca, Luca and Fop, Michael and Murphy, T Brendan and Raftery, Adrian E",
    journal = "The R journal",
    volume = "8",
    number = "1",
    pages = "289",
    year = "2016",
    publisher = "NIH Public Access"
  ),
  dempster1977maximum = bibentry("article",
    title = "Maximum likelihood from incomplete data via the EM algorithm",
    author = "Dempster, Arthur P and Laird, Nan M and Rubin, Donald B",
    journal = "Journal of the royal statistical society: series B (methodological)",
    volume = "39",
    number = "1",
    pages = "1--22",
    year = "1977",
    publisher = "Wiley Online Library"
  ),
  witten2002data = bibentry("article",
    title = "Data mining: practical machine learning tools and techniques with Java implementations",
    author = "Witten, Ian H and Frank, Eibe",
    journal = "Acm Sigmod Record",
    volume = "31",
    number = "1",
    pages = "76--77",
    year = "2002",
    publisher = "ACM New York, NY, USA"
  ),
  becker1988s = bibentry("book",
    title = "The New S Language",
    author = "Becker, Richard A and Chambers, John M and Wilks, Allan R",
    year = "1988",
    publisher = "Wadsworth & Brooks/Cole"
  ),
  everitt1974cluster = bibentry("book",
    title = "Cluster Analysis",
    author = "Everitt, Brian S",
    year = "1974",
    publisher = "Heinemann Educational Books"
  ),
  hartigan1975clustering = bibentry("book",
    title = "Clustering Algorithms",
    author = "Hartigan, John A",
    year = "1975",
    publisher = "John Wiley & Sons"
  ),
  sneath1973numerical = bibentry("book",
    title = "Numerical Taxonomy",
    author = "Sneath, Peter HA and Sokal, Robert R",
    year = "1973",
    publisher = "Freeman"
  ),
  anderberg1973cluster = bibentry("book",
    title = "Cluster Analysis for Applications",
    author = "Anderberg, Michael R",
    year = "1973",
    publisher = "Academic Press"
  ),
  gordon1999classification = bibentry("book",
    title = "Classification",
    author = "Gordon, Allan David",
    edition = "2",
    year = "1999",
    publisher = "Chapman and Hall / CRC"
  ),
  murtagh1985multidimensional = bibentry("incollection",
    title = "Multidimensional Clustering Algorithms",
    author = "Murtagh, Fionn",
    booktitle = "COMPSTAT Lectures 4",
    publisher = "Physica-Verlag",
    year = "1985"
  ),
  mcquitty1966similarity = bibentry("article",
    title = "Similarity Analysis by Reciprocal Pairs for Discrete and Continuous Data",
    author = "McQuitty, Louis L",
    journal = "Educational and Psychological Measurement",
    volume = "26",
    number = "4",
    pages = "825--831",
    year = "1966",
    doi = "10.1177/001316446602600402"
  ),
  legendre2012numerical = bibentry("book",
    title = "Numerical Ecology",
    author = "Legendre, Pierre and Legendre, Louis",
    edition = "3",
    year = "2012",
    publisher = "Elsevier Science BV"
  ),
  murtagh2014ward = bibentry("article",
    title = "Ward's Hierarchical Agglomerative Clustering Method: Which Algorithms Implement Ward's Criterion?",
    author = "Murtagh, Fionn and Legendre, Pierre",
    journal = "Journal of Classification",
    volume = "31",
    pages = "274--295",
    year = "2014",
    doi = "10.1007/s00357-014-9161-z"
  ),
  hahsler2017stream = bibentry("article",
    title = "Introduction to {stream}: An Extensible Framework for Data Stream Clustering Research with {R}",
    author = "Michael Hahsler and Matthew Bola\u00f1os and John Forrest",
    journal = "Journal of Statistical Software",
    year = "2017",
    volume = "76",
    number = "14",
    pages = "1--50",
    doi = "10.18637/jss.v076.i14",
  ),
  fichtenberger2013bico = bibentry("inproceedings",
    title = "BICO: BIRCH Meets Coresets for k-Means Clustering",
    author = "Fichtenberger, Hendrik and Gille, Marc and Schmidt, Melanie and Schwiegelshohn, Chris and Sohler, Christian",
    booktitle = "Algorithms--ESA 2013: 21st Annual European Symposium, Sophia Antipolis, France, September 2-4, 2013. Proceedings 21",
    pages = "481--492",
    year = "2013",
    organization = "Springer"
  ),
  zhang1996birch = bibentry("article",
    title = "BIRCH: An Efficient Data Clustering Method for Very Large Databases",
    author = "Zhang, Tian and Ramakrishnan, Raghu and Livny, Miron",
    journal = "ACM sigmod record",
    volume = "25",
    number = "2",
    pages = "103--114",
    year = "1996",
    publisher = "ACM New York, NY, USA"
  ),
  zhang1997birch = bibentry("article",
    title = "BIRCH: A new data clustering algorithm and its applications",
    author = "Zhang, Tian and Ramakrishnan, Raghu and Livny, Miron",
    journal = "Data Mining and Knowledge Discovery",
    volume = "1",
    pages = "141--182",
    year = "1997",
    publisher = "Springer"
  ),
  berry1979inter = bibentry("article",
    title = "Interactive Data Analysis: A Practical Primer",
    author = "Berry, J. Brian",
    journal = "Journal of the Royal Statistical Society: Series C (Applied Statistics)",
    volume = "28",
    pages = "181",
    year = "1979"
  ),
  bien2011hierarchical = bibentry("article",
    title = "Hierarchical Clustering with Prototypes via Minimax Linkage",
    author = "Bien, Jacob and Tibshirani, Robert",
    journal = "Journal of the American Statistical Association",
    volume = "106",
    number = "495",
    pages = "1075--1084",
    year = "2011",
    publisher = "Taylor & Francis"
  )
)
# nolint end
