% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_metrics.R
\name{compare_metrics}
\alias{compare_metrics}
\title{Compare different metrics}
\usage{
compare_metrics(object, ...)
}
\arguments{
\item{object}{(\link[mlr3:PredictionClassif]{mlr3::PredictionClassif} | \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult} | \link[mlr3:ResampleResult]{mlr3::ResampleResult})\cr
The object to create a plot for.
\itemize{
\item If provided a (\link[mlr3:PredictionClassif]{mlr3::PredictionClassif}).
Then the visualization will compare the fairness metrics among the binary level from protected field
through bar plots.
\item If provided a (\link[mlr3:ResampleResult]{mlr3::ResampleResult}).
Then the visualization will generate the boxplots for fairness metrics, and compare them among
the binary level from protected field.
\item If provided a (\link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult}).
Then the visualization will generate the boxplots for fairness metrics, and compare them among
both the binary level from protected field and the models implemented.
}}

\item{...}{The arguments to be passed to methods, such as:
\itemize{
\item \code{fairness_measures} (list of \link[mlr3:Measure]{mlr3::Measure})\cr
The fairness measures that will evaluated on object, could be single \link[mlr3:Measure]{mlr3::Measure} or list of \link[mlr3:Measure]{mlr3::Measure}s.
Default measure set to be \code{msr("fairness.acc")}.
\item \code{task} (\link[mlr3:TaskClassif]{mlr3::TaskClassif})\cr
The data task that contains the protected column, only required when object is (\link[mlr3:PredictionClassif]{mlr3::PredictionClassif}).
}}
}
\value{
A 'ggplot2' object.
}
\description{
Compare learners with respect to to one or multiple metrics.
Metrics can but be but are not limited to fairness metrics.
}
\section{Protected Attributes}{

The protected attribute is specified as a \code{col_role} in the corresponding \code{\link[mlr3:Task]{mlr3::Task()}}:\cr
\verb{<Task>$col_roles$pta = "name_of_attribute"} \cr
This also allows specifying more than one protected attribute,
in which case fairness will be considered on the level of intersecting groups defined by all columns
selected as a predicted attribute.
}

\examples{
\dontshow{if (rlang::is_installed("rpart") && rlang::is_installed("ranger")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library("mlr3")
library("mlr3learners")

# Setup the Fairness Measures and tasks
task = tsk("adult_train")$filter(1:500)
learner = lrn("classif.ranger", predict_type = "prob")
learner$train(task)
predictions = learner$predict(task)
design = benchmark_grid(
  tasks = task,
  learners = lrns(c("classif.ranger", "classif.rpart"),
    predict_type = "prob", predict_sets = c("train", "test")),
  resamplings = rsmps("cv", folds = 3)
)

bmr = benchmark(design)
fairness_measure = msr("fairness.tpr")
fairness_measures = msrs(c("fairness.tpr", "fairness.fnr", "fairness.acc"))

# Predictions
compare_metrics(predictions, fairness_measure, task)
compare_metrics(predictions, fairness_measures, task)

# BenchmarkResult and ResamplingResult
compare_metrics(bmr, fairness_measure)
compare_metrics(bmr, fairness_measures)
\dontshow{\}) # examplesIf}
}
