% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_dataset.R
\name{load_dataset}
\alias{load_dataset}
\title{Retrieve a Single Data Set}
\usage{
load_dataset(id, package, keep_rownames = FALSE)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Name of the data set.}

\item{package}{(\code{character(1)})\cr
Package to load the data set from.}

\item{keep_rownames}{(\code{logical(1)})\cr
Keep possible row names (default: \code{FALSE}).}
}
\description{
Loads a data set with name \code{id} from package \code{package} and returns it.
If the package is not installed, an error with condition "packageNotFoundError" is raised.
The name of the missing packages is stored in the condition as \code{packages}.
}
\examples{
head(load_dataset("iris", "datasets"))
}
