% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTaskPreprocTorch.R
\name{pipeop_preproc_torch}
\alias{pipeop_preproc_torch}
\title{Create Torch Preprocessing PipeOps}
\usage{
pipeop_preproc_torch(
  id,
  fn,
  shapes_out = NULL,
  param_set = NULL,
  packages = character(0),
  rowwise = FALSE,
  parent_env = parent.frame(),
  stages_init = NULL,
  tags = NULL
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
The id for of the new object.}

\item{fn}{(\code{function})\cr
The preprocessing function.}

\item{shapes_out}{(\code{function} or \code{NULL} or \code{"infer"})\cr
The private \code{.shapes_out(shapes_in, param_vals, task)} method of \code{\link{PipeOpTaskPreprocTorch}}
(see section Inheriting).
Special values are \code{NULL} and \code{"infer"}:
If \code{NULL}, the output shapes are unknown.
Option \code{"infer"} uses \code{\link{infer_shapes}}.
Method \code{"infer"} should be correct in most cases, but might fail in some edge cases.}

\item{param_set}{(\code{\link[paradox:ParamSet]{ParamSet}} or \code{NULL})\cr
The parameter set.
If this is left as \code{NULL} (default) the parameter set is inferred in the following way:
All parameters but the first and \code{...} of \code{fn} are set as untyped parameters with tags 'train' and those that
have no default value are tagged as 'required' as well.
Default values are not annotated.}

\item{packages}{(\code{character()})\cr
The R packages this object depends on.}

\item{rowwise}{(\code{logical(1)})\cr
Whether the preprocessing is applied row-wise.}

\item{parent_env}{(\code{environment})\cr
The parent environment for the R6 class.}

\item{stages_init}{(\code{character(1)})\cr
Initial value for the \code{stages} parameter.
If \code{NULL} (default), will be set to \code{"both"} in case the \code{id} starts with \code{"trafo"} and to \code{"train"}
if it starts with \code{"augment"}. Otherwise it must specified.}

\item{tags}{(\code{character()})\cr
Tags for the pipeop}
}
\value{
An \code{\link[R6:R6Class]{R6Class}} instance inheriting from \code{\link{PipeOpTaskPreprocTorch}}
}
\description{
Function to create objects of class \code{\link{PipeOpTaskPreprocTorch}} in a more convenient way.
Start by reading the documentation of \code{\link{PipeOpTaskPreprocTorch}}.
}
\examples{
\dontshow{if (torch::torch_is_installed()) withAutoprint(\{ # examplesIf}
PipeOpPreprocExample = pipeop_preproc_torch("preproc_example", function(x, a) x + a)
po_example = PipeOpPreprocExample$new()
po_example$param_set
\dontshow{\}) # examplesIf}
}
