% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfAndProb.R
\name{getProbForDiscrete}
\alias{getProbForDiscrete}
\title{Get a probability of a discrete value.}
\usage{
getProbForDiscrete(data, value)
}
\arguments{
\item{data}{vector of observations that have the same type as the given value.}

\item{value}{a single observation of the same type as the data vector.}
}
\value{
the probability of value given data.
}
\description{
Similar to @seealso \code{estimatePdf}, this function returns
the probability for a discrete value, given some observations.
}
\note{
If no observations are given, then this function will warn and return
a probability of zero for the value given. While we could technically return
positive infinity, 0 is more suitable in the context of Bayesian inferencing.
}
\examples{
mmb::getProbForDiscrete(data = c(), value = iris[1,]$Species)
mmb::getProbForDiscrete(data = iris$Species, value = iris[1,]$Species)
}
\author{
Sebastian Hönel \href{mailto:sebastian.honel@lnu.se}{sebastian.honel@lnu.se}
}
\keyword{likelihood}
\keyword{probability}
