% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KenRCATs.R
\name{KenRCATs}
\alias{KenRCATs}
\title{Launch KenRCATs Shiny Application}
\usage{
KenRCATs(dbname, datatable, host, port, user, password)
}
\arguments{
\item{dbname}{Character string specifying the name of the PostgreSQL database.}

\item{datatable}{Character string specifying the name of the table in the database.}

\item{host}{Character string specifying the host name or IP address of the database server.}

\item{port}{Integer specifying the port number on which the database is running.}

\item{user}{Character string specifying the username for database connection.}

\item{password}{Character string specifying the password for database connection.}
}
\value{
A 'shiny' app object.
}
\description{
This function launches a 'shiny' application for conducting power analysis
simulations using CATs (Clustered Adjusted t-statistics) and Kenward-Roger
methods. The app allows users to input simulation parameters, run simulations,
view results, and manage data in a PostgreSQL database.
}
\details{
The KenRCATs function sets up a Shiny application with the following features:
\itemize{
\item Input fields for various simulation parameters
\item Ability to run power analysis simulations
\item Display of simulation results
\item Option to submit results to a PostgreSQL database
\item Functionality to download data from the database
\item Display of relevant citations
}
}
\examples{
if(interactive()){
  KenRCATs(
    dbname = "your_database_name",
    datatable = "your_table_name",
    host = "localhost",
    port = 5432,
    user = "your_username",
    password = "your_password"
  )
}

}
