% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_check_columns_nested}
\alias{h_check_columns_nested}
\title{Predicate Indicating Whether Two Datasets Contain the Same Observations}
\usage{
h_check_columns_nested(data_basic, data_augmented)
}
\arguments{
\item{data_basic, data_augmented}{(\code{data.frame})\cr data frames to be
compared.}
}
\value{
\code{TRUE} or \code{FALSE}, indicating whether the or not \code{data_basic} and
\code{data_augmented} contain the same observations and that \code{data_augmented}
contains all the columns in \code{data_basic}.
}
\description{
Checks whether two datasets contain the same observations and that the first
dataset's columns are a subset of the second dataset's columns.
}
\details{
For efficiency, the inspection takes place in this order:
\enumerate{
\item \code{FALSE} is returned early if the datasets do not have the same number of
rows.
\item \code{FALSE} is returned early if the first dataset has a column not in the
second dataset.
\item The columns in common are sorted and compared using \code{\link[=all.equal]{all.equal()}} with
\code{check.attributes = FALSE}.
}
}
\seealso{
\code{\link[=h_check_fits_all_data_same]{h_check_fits_all_data_same()}}, which performs this check on the
datasets of adjacent elements of a list of \code{mmrm} fits.
}
\keyword{internal}
