% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mniw-package.R
\docType{package}
\name{mniw-package}
\alias{mniw}
\alias{mniw-package}
\title{Tools for the Matrix-Normal Inverse-Wishart distribution.}
\description{
Density evaluation and random number generation for the Matrix-Normal Inverse-Wishart (MNIW) distribution, as well as its constituent distributions, i.e., the Matrix-Normal, Matrix-T, Wishart, and Inverse-Wishart distributions.
}
\details{
The Matrix-Normal Inverse-Wishart (MNIW) distribution \eqn{(\boldsymbol{X}, \boldsymbol{V}) \sim \textrm{MNIW}(\boldsymbol{\Lambda}, \boldsymbol{\Sigma}, \boldsymbol{\Psi}, \nu)}{(X, V) ~ MNIW(\Lambda, \Sigma, \Psi, \nu)} on random matrices \eqn{\boldsymbol{X}_{p \times q}}{X_(p x q)} and symmetric positive-definite \eqn{\boldsymbol{V}_{q\times q}}{V_(q x q)} is defined as
\deqn{
\begin{array}{rcl}
\boldsymbol{V} & \sim & \textrm{Inverse-Wishart}(\boldsymbol{\Psi}, \nu) \\
\boldsymbol{X} \mid \boldsymbol{V} & \sim & \textrm{Matrix-Normal}(\boldsymbol{\Lambda}, \boldsymbol{\Sigma}, \boldsymbol{V}),
\end{array}
}{
V ~ Inverse-Wishart(\Psi, \nu)
X | V ~ Matrix-Normal(\Lambda, \Sigma, V),
}
where the Matrix-Normal distribution is defined as the multivariate normal
\deqn{
\textrm{vec}(\boldsymbol{X}) \sim \mathcal{N}(\textrm{vec}(\boldsymbol{\Lambda}), \boldsymbol{V} \otimes \boldsymbol{\Sigma}),
}{
vec(X) ~ N(vec(\Lambda), V \%x\% \Sigma),
}
where \eqn{\textrm{vec}(\boldsymbol{X})}{vec(X)} is a vector stacking the columns of \eqn{\boldsymbol{X}}{X}, and \eqn{\boldsymbol{V} \otimes \boldsymbol{\Sigma}}{V \%x\% \Sigma} denotes the Kronecker product.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mlysy/mniw/}
  \item \url{https://mlysy.github.io/mniw/}
  \item Report bugs at \url{https://github.com/mlysy/mniw/issues}
}

}
\author{
\strong{Maintainer}: Martin Lysy \email{mlysy@uwaterloo.ca}

Authors:
\itemize{
  \item Bryan Yates
}

}
