% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mobr_boxplots.R
\name{calc_SPIE}
\alias{calc_SPIE}
\title{Calculate S_PIE}
\usage{
calc_SPIE(x, replace = F)
}
\arguments{
\item{x}{can either be a: 1) mob_in object, 2) community matrix-like
object in which rows represent plots and columns represent species, or 3)
a vector which contains the abundance of each species.}

\item{replace}{if TRUE, sampling with replacement is used. Otherwise,
sampling without replacement (default).}
}
\value{
either a single S_PIE value or vector of S_PIE values.
}
\description{
S_PIE is the effective number of species transformation of the probability of
interspecific encounter (PIE) which is equal to the number of equally common
species that result in that value of PIE.
}
\details{
By default the sample size corrected version is returned (\code{replace =
F}), which is the asymptotic estimator for the Hill number of diversity order
q=2 (Chao et al, 2014). If \code{replace = T} the uncorrected hill number is
returned. This is the same as vegan::diversity(x, index="invsimpson").
}
\examples{
data(inv_comm)
calc_SPIE(inv_comm)
calc_SPIE(inv_comm, replace = TRUE)
calc_SPIE(c(23,21,12,5,1,2,3), replace=TRUE)
}
\references{
Chao, A., Gotelli, N. J., Hsieh, T. C., Sander, E. L., Ma, K. H., Colwell, R.
K., & Ellison, A. M. (2014). Rarefaction and extrapolation with Hill numbers:
A framework for sampling and estimation in species diversity studies.
Ecological Monographs 84(1), 45-67.
}
\seealso{
\code{\link{calc_PIE}}
}
