% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidth_cross_validation.R
\name{bandwidth_cross_validation}
\alias{bandwidth_cross_validation}
\title{Cross-validation bandwidth for local polymnomial estimator of a psychometric function}
\usage{
bandwidth_cross_validation( r, m, x, H, link = "logit", guessing = 0,
                           lapsing = 0, K = 2, p = 1, ker = "dnorm",
                           maxiter = 50, tol = 1e-6, method = "all")
}
\arguments{
\item{r}{number of successes at points x}

\item{m}{number of trials at points x}

\item{x}{stimulus levels}

\item{H}{search interval}

\item{link}{(optional) name of the link function to be used; default is "logit"}

\item{guessing}{(optional) guessing rate; default is 0}

\item{lapsing}{(optional) lapsing rate; default is 0}

\item{K}{(optional) power parameter for Weibull and reverse Weibull link; default is 2}

\item{p}{(optional) degree of the polynomial; default is 1}

\item{ker}{(optional) kernel function for weights; default is "dnorm"}

\item{maxiter}{(optional) maximum number of iterations in Fisher scoring; default is 50}

\item{tol}{(optional) tolerance level at which to stop Fisher scoring; default is 1e-6}

\item{method}{(optional) loss function to be used in cross-validation: choose from: "ISEeta", "ISE", "deviance"; by default all possible values are calculated}
}
\value{
\verb{h  } cross-validation bandwidth for the chosen "method"; if no "method" is specified, then it has three components: $pscale, $etascale and $deviance
}
\description{
This function finds the cross-validation bandwidth for a local polynomial estimate of
the psychometric function with specified guessing and lapsing rates.
}
\examples{
data("Miranda_Henson")
x = Miranda_Henson$x
r = Miranda_Henson$r
m = Miranda_Henson$m
numxfit <- 199; # Number of new points to be generated minus 1
xfit <- (max(x)-min(x)) * (0:numxfit) / numxfit + min(x)
# Find a cross-validation bandwidth
bwd_min <- min( diff( x ) )
bwd_max <- max( x ) - min( x )
bwd <- bandwidth_cross_validation( r, m, x, c( bwd_min, bwd_max ) )
bwd <- bwd$deviance # Choose the estimate based on cross-validated deviance
pfit <- locglmfit( xfit, r, m, x, bwd )$pfit
# Plot the fitted curve
plot( x, r / m, xlim = c( 0.1, 1.302 ), ylim = c( 0.0165, 0.965 ), type = "p", pch="*" )
lines(xfit, pfit )
}
