% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locglmfit.R
\name{locglmfit}
\alias{locglmfit}
\title{Local polynomial estimator of a psychometric function}
\usage{
locglmfit( xfit, r, m, x, h, returnH = FALSE, link = "logit",
               guessing = 0, lapsing = 0, K = 2, p = 1,
               ker = "dnorm", maxiter = 50, tol = 1e-6 )
}
\arguments{
\item{xfit}{points at which to calculate the estimate pfit}

\item{r}{number of successes at points x}

\item{m}{number of trials at points x}

\item{x}{stimulus levels}

\item{h}{bandwidth(s)}

\item{returnH}{(optional) logical, if TRUE then hat matrix is calculated; default is FALSE}

\item{link}{(optional) name of the link function; default is 'logit'}

\item{guessing}{(optional) guessing rate; default is 0}

\item{lapsing}{(optional) lapsing rate; default is 0}

\item{K}{(optional) power parameter for Weibull and reverse Weibull link; default is 2}

\item{p}{(optional) degree of the polynomial; default is 1}

\item{ker}{(optional) kernel function for weights; default is 'dnorm'}

\item{maxiter}{(optional) maximum number of iterations in Fisher scoring; default is 50}

\item{tol}{(optional) tolerance level at which to stop Fisher scoring; default is 1e-6}
}
\value{
\verb{pfit    }    value of the local polynomial estimate at points xfit

\verb{etafit  }  estimate of eta (link of pfit)

\verb{H       }       hat matrix (OPTIONAL)
}
\description{
Local polynomial estimator for the psychometric function and eta function (psychometric function
transformed by link) for binomial data; also returns the hat matrix H.
}
\examples{
data("Miranda_Henson")
x = Miranda_Henson$x
r = Miranda_Henson$r
m = Miranda_Henson$m
numxfit <- 199; # Number of new points to be generated minus 1
xfit <- (max(x)-min(x)) * (0:numxfit) / numxfit + min(x)
# Find a plug-in bandwidth
bwd <- bandwidth_plugin( r, m, x)
pfit <- locglmfit( xfit, r, m, x, bwd )$pfit
# Plot the fitted curve
plot( x, r / m, xlim = c( 0.1, 1.302 ), ylim = c( 0.0165, 0.965 ), type = "p", pch="*" )
lines(xfit, pfit )

}
