% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mleMOGIW.R
\name{mleMOGIW}
\alias{mleMOGIW}
\title{Numerical method for maximum likelihood estimation}
\usage{
mleMOGIW(x, param, method = "L-BFGS-B")
}
\arguments{
\item{x}{vector of data.}

\item{param}{inintial four parameters (\code{alpha}, \code{beta}, \code{lambda}, and \code{beta})}

\item{method}{a numerical method for maximum likelihood estimation, a default method is "L-BFGS-B",
the other specify "BFGS"}
}
\value{
\code{outout} is a list of variables as follows:
\code{est_param} gives the estimated four parameters,
\code{neg_likelihood} gives the negative-log-likelihood value,
\code{code_conversgence} is code of convergence, if \code{0}, convergence , otherwise, divergence.
\code{num_method} is numerical method, a default method is \code{"L-BFGS-B"}
}
\description{
In maximum likelihood estimation, if the Hessian matrix is difficult to obtain,
 Numerical method (means an iteration optimization method) will be used to obtain the model parameter.
}
\examples{
y <- rMOGIW(100,1,3,2,3)
pars <- c(alpha=1, beta=3, lambda=2, theta=3)
mleMOGIW(x=y,param=pars,method = "L-BFGS-B")

}
\references{
Zhu, C., Byrd, R. H., Lu, P., & Nocedal, J. (1997). Algorithm 778: L-BFGS-B.
ACM Transactions on Mathematical Software, 23(4), 550–560. https://doi.org/10.1145/279232.279236.
}
