% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medoid.R
\name{medoid}
\alias{medoid}
\title{Find Medoid of the Cluster}
\usage{
medoid(members, dist_mat)
}
\arguments{
\item{members}{index vector indicating which observation belongs to the
cluster.}

\item{dist_mat}{distance matrix of the whole data set. A class of \code{dist}
object must be coerced to a matrix before using.}
}
\value{
index of the medoid point in the members vector.
}
\description{
Medoid is the point that has minimum distance to all other points in the
cluster.
}
\examples{
\donttest{
library(cluster)
data(ruspini)
ruspini4sol <- MonoClust(ruspini, nclusters = 4)
ruspini4sol

medoid(which(ruspini4sol$membership == 4), ruspini4sol$dist)

# Check with the output with "4" label
ruspini4sol$medoids
}
}
