% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{match_na_raster}
\alias{match_na_raster}
\title{Match NA cells for all layers in SpatRaster}
\usage{
match_na_raster(layers)
}
\arguments{
\item{layers}{a \code{SpatRaster} object containing two or more variables to be
matched.}
}
\value{
A \code{SpatRaster} object with NA cells matching in all layers.
}
\description{
Option to match cells with NA values in a SpatRaster with multiple layers.
}
\examples{
# data
layers <- terra::rast(system.file("extdata", "reference_layers.tif",
                      package = "mop"))

# add NA in some places
layers[20:24, 10:16][, 3] <- NA
terra::plot(layers)

# match NAs
matched <- match_na_raster(layers)
terra::plot(matched)
}
