% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-BinaryData.R, R/data-ContinuousData.R,
%   R/data-CountData.R, R/data.R
\name{CheckData}
\alias{CheckData}
\alias{binaryDataCheck}
\alias{continuousDataCheck}
\alias{countDataCheck}
\title{Checking object structure for analysis}
\usage{
binaryDataCheck(data, quiet = FALSE)

continuousDataCheck(data, quiet = FALSE)

countDataCheck(data, quiet = FALSE)
}
\arguments{
\item{data}{Any object, but usually a \code{list} or a \code{data.frame}.}

\item{quiet}{Binary. Default is \code{False}. If \code{True} it returns messages
of the checking function.}
}
\value{
The function returns a \code{data.frame} with message describing the error in the
formatting of the data. When no error is detected the object is empty.
\itemize{
\item For \code{\link{countDataCheck}}, the function returns a \code{data.frame} similar
to the one returned by \code{\link{binaryDataCheck}},
except that it may contain the following additional error \code{id}s:
\itemize{
\item \code{NreproInteger}: column \code{Nrepro} contains values of class other than \code{integer}
\item \code{Nrepro0T0}: \code{Nrepro} is not 0 at time 0 for each concentration and each replicate
\item \code{Nsurvt0Nreprotp1P}: at a given time \eqn{T}, the number of
alive individuals is null and the number of collected offspring is not null
for the same replicate and the same concentration at time \eqn{T+1}
}
}
}
\description{
Checks if an object can be used to perform data analysis.
\itemize{
\item \code{binaryDataCheck}: the function can be used to check if an object
containing survival data is formatted according to the expectations of the
\code{BinaryData} function.
\item \code{continuousDataCheck}: the function can be used to check if an object
containing survival data is formatted according to the expectations of the
\code{\link{continuousData}} function.
\item \code{countDataCheck}: the function can be used to check if an object
containing data from a reproduction toxicity assay meets the expectations
of the function \code{\link{countData}}.
The \code{countDataCheck} performs the same checking than
\code{\link{binaryDataCheck}} plus additional ones that are specific to
reproduction data.
}
}
\examples{
data(chlordan_daphnia)
continuousDataCheck(chlordan_daphnia)


# Run the check data function
data(copper)
countDataCheck(copper)

# Now we insert an error in the data set, by setting a non-zero number of
# offspring at some time, although there is no surviving individual in the
# replicate from the previous time point.
copper[148, "Nrepro"] <- as.integer(1)
countDataCheck(copper)

}
\seealso{
\code{\link{binaryData}}

\code{\link{countData}}

\code{\link{continuousData}}
}
