% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-SurvData.R
\name{CheckData}
\alias{CheckData}
\alias{check_time}
\alias{check_concentration}
\alias{check_Nsurv}
\alias{check_TimeNsurv}
\alias{check_concNsurv}
\alias{checking_table}
\alias{is_exposure_constant}
\alias{is.between}
\title{Set of function to test conformity of data}
\usage{
check_time(data)

check_concentration(data)

check_Nsurv(data)

check_TimeNsurv(data)

check_concNsurv(data)

checking_table(data, check, msg)

is_exposure_constant(data)

is.between(x, min, max)
}
\arguments{
\item{data}{a data.frame}

\item{check}{binary vector of TRUE/FALSE}

\item{msg}{a message to add to the data.frame}

\item{x}{parameter to check if it's between min and max}

\item{min}{minimal value. x must be greater than min}

\item{max}{maximal value. x must be lower than max}
}
\value{
a boolean \code{TRUE} if concentration in \code{replicate} is constant,
or \code{FALSE} if the concentration in at least one of the replicates is time-variable,
and/or if \code{NA} occurs.
}
\description{
\itemize{
\item \strong{check_time}: check if the \code{time} within a \code{time serie}
is (1) numeric, (2) unique, (3) minimal value is 0.
\item \strong{check_concentration}: check if the \code{concentration} is numeric
and always positive.
\item \strong{check_Nsurv}: check if the \code{Nsurv} is (1) integer and
(2) always positive (3) can be NA.
\item \strong{check_TimeNsurv}: check if the pair \code{time} - \code{Nsurv} within
a \code{time serie} satisfies (1) Nsurv at t=0 is >0, (2) decreasing.
\item \strong{check_concNsurv}: check if the pair \code{conc} - \code{Nsurv} within
a \code{time serie} satisfies that the timeline of concentration covers
timeline of Nsurv.
\item \strong{checking_table}: add \code{msg} in a data.frame \code{data} if
\code{check} are not all TRUE.
\item \strong{is_exposure_constant}: Test in a well-formed argument to function
\code{SurvData} if the concentration is constant and different
from \code{NA} for each replicate (each time-serie).
\item \strong{is.between}: Test if \code{x} is between \code{min} and \code{max}
}
}
