% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{drift}
\alias{drift}
\title{Dead and drifting}
\usage{
drift(
  data,
  type,
  ID,
  station,
  res.start = "auto",
  res.end = "auto",
  residences = "auto",
  units = "auto",
  ddd,
  from.station,
  to.station,
  cutoff = NULL,
  cutoff.units = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{a data frame of residence events. Residence events must include
tag ID, location name, start time, and end time.}

\item{type}{the method used to generate the residence events in \code{data}.
Options are "mort", "actel", "glatos", "vtrack", or "manual". If "manual", then
user must specify \code{ID}, \code{station}, \code{res.start}, and \code{res.end}.}

\item{ID}{a string of the name of the column in \code{data} that holds the tag or
sample IDs.}

\item{station}{a string of the name of the column in \code{data} that holds the
station name or receiver location.}

\item{res.start}{a string of the name of the column in \code{data} that holds the
start date and time. Must be specified and in POSIXt or character in the format
YYYY-mm-dd HH:MM:SS if \code{type="manual"}.}

\item{res.end}{a string of the name of the column in \code{data} that holds the
end date and time. Must be specified and in POSIXt or character in the format
YYYY-mm-dd HH:MM:SS if \code{type="manual"}.}

\item{residences}{a character string with the name of the column in \code{data}
that holds the duration of the residence events.}

\item{units}{units of the duration of the residence events in \code{data}.}

\item{ddd}{a dataframe of stations/locations where detected movement between
stations may be due to drifting of an expelled tag or dead animal.}

\item{from.station}{a string of the name of the column in \code{data} that contains
the station/location names where drifting detections may start from.}

\item{to.station}{a string of the name of the column in \code{data} that contains
the station/location names where drifting detections may move to.}

\item{cutoff}{the maximum allowable time difference between detections to be
considered a single residence event. Default is \code{NULL}.}

\item{cutoff.units}{the units of the cutoff. Options are "secs", "mins", "hours",
"days", and "weeks".}

\item{verbose}{option to display progress bar as \code{drift} is applied.
Default is TRUE.}
}
\value{
A data frame with one row for each residence event. Format is the
same as the input residence events, but events that may be due to dead drift
are combined into single residence events.
}
\description{
Identifies sequential residence events where detected movement
between stations may be due to drifting of an expelled tag or dead animal.
}
\examples{
# With no drift:
head(events)

drift.events<-drift(data=events[events$ID=="A",],type="mort",ID="ID",
station="Station.Name",ddd=ddd,from.station="From",to.station="To",
verbose=FALSE)
head(drift.events)

# With cutoff:
drift.events<-drift(data=events[events$ID=="A",],type="mort",ID="ID",
station="Station.Name",ddd=ddd,from.station="From",to.station="To",
cutoff=1,cutoff.units="days",verbose=FALSE)
head(drift.events)
}
