% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mo_topple}
\alias{mo_topple}
\title{Moments of Order Statistics from the Topp-Leone Distribution}
\usage{
mo_topple(r, n, k = 1, a, b = 1)
}
\arguments{
\item{r}{rank(s) of the desired order statistic(s) (e.g., \code{1} for the smallest order statistic).}

\item{n}{sample size from which the order statistic is derived.}

\item{k}{order of the moment to compute (default is \code{1}).}

\item{a}{shape parameter of the topp-leone distribution (\code{a} > \code{0}).}

\item{b}{scale parameter of the topp-leone distribution (default is \code{1}, \code{b} > \code{0}).}
}
\value{
The \eqn{k}th moment of the \eqn{r}th order statistic from a topp-leone distribution.
}
\description{
This function computes the moments of order statistic from the topp-leone distribution, based on the formula
presented in Genç, A. İ. (2012).
}
\details{
This function implements the exact formula for moments of order statistics from the
topp-leone distribution as provided in Genç, A. İ. (2012):
\deqn{
\text{E}[X_{r:n}^k] = \frac{n!(ab^k)}{(r-1)!(n-r)!} \sum_{j=0}^{n-r} \binom{n-r}{j} (-1)^j
2^{k + 2a(r+j)} \left[ B_{1/2}(k + a(r+j), a(r+j)) - 2 B_{1/2}(k + a(r+j) + 1, a(r+j)) \right]
}
Here, \eqn{B_x(., .)} is the incomplete Beta function.
}
\examples{
# Compute the first moment of the first order statistic for n=5, a=2, b=1
mo_topple(1, 5, 1, 2)

# Compute the second moment of the second order statistic for n=10, a=1.5, b=2
mo_topple(2, 10, 2, 1.5, 2)

}
\references{
Genç, A. İ. (2012). \emph{Moments of order statistics of Topp–Leone distribution.}
Statistical Papers, 53, 117-131.
}
