% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mo_weibull}
\alias{mo_weibull}
\title{Moments of Order Statistics from the Weibull Distribution}
\usage{
mo_weibull(r, n, k = 1, shape, scale = 1)
}
\arguments{
\item{r}{rank(s) of the desired order statistic(s) (e.g., \code{1} for the smallest order statistic).}

\item{n}{sample size from which the order statistic is derived.}

\item{k}{order of the moment to compute (default is \code{1}).}

\item{shape}{shape parameter of the weibull distribution.}

\item{scale}{scale parameter of the weibull distribution (default is \code{1}).}
}
\value{
The \eqn{k}th moment of the \eqn{r}th order statistic from a weibull distribution.
}
\description{
This function computes the moments of order statistics from the weibull distribution.
}
\details{
The function calculates the \eqn{k}th moment using the formula:
\deqn{
\text{E}[X_{r:n}^k] = \frac{n!}{(r-1)!(n-r)!} \Gamma\left(1 + \frac{k}{\text{shape}}\right)
\sum_{j=0}^{r-1} (-1)^j \binom{r-1}{j} \frac{1}{(n-r+1+j)^{1 + \frac{k}{\text{shape}}}}
}
For non-standard weibull distributions (\code{scale} not equal to 1), the relationship
\eqn{\text{E}[Z_{r:n}^k] = \text{scale}^k \text{E}[X_{r:n}^k]} is used.
}
\examples{
# Example 1: Standard weibull distribution (shape = 2, scale = 1)
mo_weibull(r = 2, n = 5, k = 1, shape = 2)

# Example 2: Non-standard weibull distribution (shape = 2, scale = 3)
mo_weibull(r = 3, n = 6, k = 2, shape = 2, scale = 3)

}
\references{
Harter, H. L., & Balakrishnan, N. (1996). \emph{CRC handbook of tables for the use of order statistics in estimation.} CRC press.
}
