% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitdistr.R
\name{fit_distr_fun}
\alias{fit_distr_fun}
\title{Fit a distribution to data and return a function}
\usage{
fit_distr_fun(data, formula, dist, start = NULL, ...)
}
\arguments{
\item{data}{A data frame.}

\item{formula}{A formula.  A distribution will be fit to the data defined by the
right side and evaluated in \code{data}.}

\item{dist}{A string naming the function desired.  Tyically this will be
"d", "p", "q", or "r" followed by the (abbrevation for) a family of
distributions such as "pnorm", "rgamma". Fitting is done use
\code{\link[MASS:fitdistr]{MASS::fitdistr()}}; see the help there for a list of distributions that
are available.}

\item{start}{Starting values for the numerical maximum likelihood method
(passed to \code{MASS::fitdistr}).}

\item{...}{Additional arguments to MASS::fitdistr()}
}
\value{
A function of one variable that acts like, say,
\code{pnorm()}, \code{dnorm()}, \code{qnorm()}, or \code{rnorm()}, but with the default
values of the parameters set to their maximum likelihood estimates.
}
\description{
Given the name of a family of 1-dimensional distributions, this function chooses a
particular member  of the family that fits the data and returns a function in the
selected p, d, q, or r format. When analytical solutions do not exist, \code{MASS::fitdistr()}
is used to estimate the parameters by numerical maximum likelihood.
}
\examples{

fit_distr_fun( ~ cesd, data = mosaicData::HELPrct, dist = "dnorm")
fit_distr_fun( ~ cesd, data = mosaicData::HELPrct, dist = "pnorm")
fit_distr_fun( ~ cesd, data = mosaicData::HELPrct, dist = "qpois")
}
