% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps2.R
\name{mUSMap}
\alias{mUSMap}
\title{Make a US map with \code{ggplot2}}
\usage{
mUSMap(
  data = NULL,
  key,
  fill = NULL,
  plot = c("borders", "frame", "none"),
  style = c("compact", "real")
)
}
\arguments{
\item{data}{A dataframe with US states as cases}

\item{key}{The column name in the \code{data} that holds the unique
names of each state}

\item{fill}{A variable in the \code{data} used to specify the fill
color of states in the map (note: if \code{fill} is not null, then
\code{plot} cannot be set to "none")}

\item{plot}{The plot desired for the output. \code{plot} = "none"
returns the merged data that is the result of merging the \code{data}
and the dataframe with the geographical coordinate information;
\code{plot} = "frame" returns an empty (unplottable) ggplot object;
\code{plot} = "border" (the default) returns a ggplot object with
one geom_polygon layer that shows the borders of the states}

\item{style}{The style in which to display the map. \code{compact} gives
a polyconic projection with Alaska and Hawaii on the lower left corner;
\code{real} gives the real size and position of all states without any
projection.}
}
\description{
\code{mUSMap} takes in one dataframe that includes information
about different US states. It merges this dataframe with a dataframe
that includes geographical coordinate information. Depending on the
arguments passed, it returns this data or a ggplot object constructed
with the data.
}
\examples{
USArrests2 <- USArrests |> tibble::rownames_to_column("state")
mUSMap(USArrests2, key="state", fill = "UrbanPop") 
}
