% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_prune.R
\name{plot.multiscale.cpts}
\alias{plot.multiscale.cpts}
\title{Plotting the output from multiscale MOSUM procedure}
\usage{
\method{plot}{multiscale.cpts}(
  x,
  display = c("data", "significance")[1],
  shaded = c("CI", "bandwidth", "none")[1],
  level = 0.05,
  N_reps = 1000,
  CI = c("pw", "unif")[1],
  xlab = "Time",
  ...
)
}
\arguments{
\item{x}{a \code{multiscale.cpts} object}

\item{display}{which to be plotted against the estimated change point locations; possible values are
\itemize{
   \item{\code{"data"}}{input time series is plotted along with the estimated piecewise constant signal}
   \item{\code{"significance"}}{one minus the p-values associated with the detection of change point estimators
   are represented as the height of vertical lines indicating their locations}
}}

\item{shaded}{string indicating which to display as shaded areas surrounding the estimated change point locations.
Poissble values are 
\itemize{
   \item{\code{"bandwidth"}}{respective detection intervals are plotted} 
   \item{\code{"CI"}}{bootstrap confidence intervals are plotted}
   \item{\code{"none"}}{none is plotted}
}}

\item{level, N_reps}{argument to be parsed to \link[mosum]{confint.multiscale.cpts}; use iff \code{shaded = "CI"}.}

\item{CI}{string indicating whether pointwise (\code{CI = "pw"}) or uniform (\code{CI = "unif"}) confidence intervals
are to be plotted; use iff \code{shaded = "CI"}}

\item{xlab}{graphical parameter}

\item{...}{not in use}
}
\description{
Plotting method for S3 objects of class "multiscale.cpts".
}
\details{
The locations of change point estimators are plotted 
against the input time series and the estimated piecewise constant signal (\code{display = "data"}), or 
the significance of each estimator is represented by the corresponding
\code{1-p.value} derived from the asymptotic distribution of MOSUM test statistic (\code{display = "significance"}).
It also produces the rectangles representing the 
detection intervals (if \code{shaded = "bandwidth"}) or 
bootstrap confidence intervals of the corresponding change points (if \code{shaded = "CI"})
around their locations.
}
\examples{
x <- testData(model = "blocks", seed = 1234)$x
mlp <- multiscale.localPrune(x)
par(mfrow = c(2, 1))
plot(mlp, display = "data", shaded = "bandwidth")
plot(mlp, display = "significance", shaded = "CI")
}
