% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{list_all_databases}
\alias{list_all_databases}
\title{List Databases Visible to the Connection}
\usage{
list_all_databases(.con)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}
}
\value{
A \code{dbplyr} lazy tibble with one column: \code{table_catalog}.
}
\description{
Returns a lazy tibble of distinct database (catalog) names visible through
the current connection, using \code{information_schema.tables}.
}
\details{
The result is a \code{dbplyr} lazy table (\code{tbl_dbi}). Use \code{dplyr::collect()} to bring
results into R as a local tibble.
}
\seealso{
Other db-list: 
\code{\link{list_all_tables}()},
\code{\link{list_current_schemas}()},
\code{\link{list_current_tables}()},
\code{\link{list_extensions}()},
\code{\link{list_fns}()},
\code{\link{list_setting}()},
\code{\link{list_shares}()}
}
\concept{db-list}
