% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWindEstimate.R
\docType{methods}
\name{getWindEstimate}
\alias{getWindEstimate}
\alias{getWindEstimate,matrix,numeric-method}
\alias{getWindEstimate,matrix,numeric,ANY-method}
\title{Estimate wind speed from a sample of ground speeds}
\usage{
getWindEstimate(groundSpeeds, phi, windStart = c(0, 0))

\S4method{getWindEstimate}{matrix,numeric}(groundSpeeds, phi, windStart = c(0, 0))
}
\arguments{
\item{groundSpeeds}{matrix with two columns representing the ground speeds.}

\item{phi}{numeric of length one giving the auto correlation.}

\item{windStart}{numeric of length 2 giving the wind speed where to optimize from.}
}
\value{
an list with parameter estimates
}
\description{
Estimate wind speed from a sample of ground speeds
}
\examples{
s<-seq(0,2*pi, .1)
set.seed(34)
getWindEstimate(cbind(4*cos(s)+3+rnorm(length(s)), 4*sin(s)+2+rnorm(length(s))),0)
getWindEstimate(cbind(4*cos(s)+3+rnorm(length(s),sd=.2), 4*sin(s)+2+rnorm(length(s),sd=.2)),0)
}
