% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_diagnostics.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot.Duration}
\alias{autoplot.OnsetsSelected}
\alias{autoplot.Metre}
\alias{autoplot.View}
\alias{autoplot.SplicedView}
\title{Diagnostic plots}
\usage{
\method{autoplot}{Duration}(object, horizontal = FALSE, ...)

\method{autoplot}{OnsetsSelected}(object, instrument = "Inst", tactus = "Matra", ...)

\method{autoplot}{Metre}(object, ...)

\method{autoplot}{View}(
  object,
  columns = NULL,
  maxpts = 1000,
  time_limits = c(-Inf, Inf),
  time_breaks = NULL,
  expr = NULL,
  ...
)

\method{autoplot}{SplicedView}(
  object,
  columns = NULL,
  segments = NULL,
  time_breaks = NULL,
  time_limits = c(-Inf, Inf),
  maxpts = 1000,
  ...
)
}
\arguments{
\item{object}{S3 object}

\item{horizontal}{make the barchart horizontal? (Default is FALSE).}

\item{...}{passed to \code{\link[zoo:plot.zoo]{zoo::plot.zoo()}}.}

\item{instrument}{instrument column name.}

\item{tactus}{beat column name.}

\item{columns}{names of columns in input data.}

\item{maxpts}{maximum number of points to plot}

\item{time_limits}{tuple to restrict the timeline or a duration object.}

\item{time_breaks}{suggests the number of major time tick marks (Default is NULL).}

\item{expr}{an R expression that sets the time scale using a duration object (Default is NULL).}

\item{segments}{only include these segments in a SplicedView plot.}
}
\value{
a ggplot object.
}
\description{
Autoplot methods for S3 objects in the movementsync package.
}
\examples{
r <- get_sample_recording()
d <- get_duration_annotation_data(r)
autoplot(d)
o <- get_onsets_selected_data(r)
autoplot(o)
m <- get_metre_data(r)
autoplot(m)
v <- get_raw_view(r, "Central", "", "Sitar")
autoplot(v, columns = c("LEar_x", "LEar_y"), time_limits = c(20, 40))
l <- list(a = c(0, 10), b = c(20, 30), c = c(30, 60))
splicing_df <- splice_time(l)
sv <- get_spliced_view(v, splicing_df)
autoplot(sv, columns = c("LEar_x", "LEar_y", "Nose_x", "Nose_y"), time_breaks = 4, maxpts = 1000)
}
