% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granger.R
\name{plot_influence_diagram}
\alias{plot_influence_diagram}
\title{Plot influence diagram from a GrangerTest object}
\usage{
plot_influence_diagram(obj, splicing_df, two_arrows = TRUE, lev_sig = 0.05)
}
\arguments{
\item{obj}{GrangerTest object}

\item{splicing_df}{Splicing data.frame object}

\item{two_arrows}{plot influence arrows both ways? (Default is TRUE).}

\item{lev_sig}{significance level}
}
\value{
ggplot object
}
\description{
Arrows show causality (influencing) direction.
}
\details{
By default \code{two_arrows} is TRUE and an influencing arrow is drawn for each
significant p-value. If \code{two_arrows} is FALSE and one
of the p-values is signficant then -log10(p_value) difference is plotted i.e
}
\examples{
r1 <- get_sample_recording()
fv_list <- get_filtered_views(r1, data_points = "Nose", n = 41, p = 3)
jv_sub <- get_joined_view(fv_list)
splicing_df <- splice_time(jv_sub, win_size = 3, step_size = 0.5)
sv <- get_spliced_view(jv_sub, splicing_df)
g <- granger_test(sv, "Nose_x_Central_Sitar", "Nose_x_Central_Tabla", lag = 3/25)

plot_influence_diagram(g, splicing_df)
plot_influence_diagram(g, splicing_df, two_arrows = TRUE)

d1 <- get_duration_annotation_data(r1)
plot_influence_diagram(g, splicing_df) +
autolayer(d1, expr = (Tier == "Influence S>T" | Tier == "Influence T>S") & Out <= 60,
          fill_col = "Tier")
}
\seealso{
Other Granger Causality: 
\code{\link{autoplot.GrangerTime}()},
\code{\link{get_granger_interactions}()},
\code{\link{granger_test}()},
\code{\link{map_to_granger_test}()},
\code{\link{ms_condgrangertest}()},
\code{\link{ms_grangertest1}()},
\code{\link{ms_grangertest2}()},
\code{\link{plot.GrangerInteraction}()}
}
\concept{Granger Causality}
