% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{splice_time.Metre}
\alias{splice_time.Metre}
\title{Generate spliced timeline using a Metre object}
\usage{
\method{splice_time}{Metre}(
  x,
  window_duration = NULL,
  window_proportion = NULL,
  tactus = NULL,
  ...
)
}
\arguments{
\item{x}{\code{Metre} object.}

\item{window_duration}{duration of window around beat
(may lead to overlapping windows if large).}

\item{window_proportion}{sets the window duration around beat based on a
proportion (0, 0.5] of the gap to the previous and following cycles. The first
and last beats in each Metre are removed.}

\item{tactus}{vector of Metres to subset on.}

\item{...}{ignored.}
}
\value{
a \code{Splice} object.
}
\description{
Generate spliced timeline using a Metre object
}
\examples{
r <- get_sample_recording()
m <- get_metre_data(r)
splicing_df <- splice_time(m, window_duration = 1)
head(splicing_df)
splicing_df <- splice_time(m, window_proportion = 0.25)
head(splicing_df)
}
\seealso{
Other splicing functions: 
\code{\link{clip_splice}()},
\code{\link{get_spliced_view}()},
\code{\link{is_splice_overlapping}()},
\code{\link{merge_splice}()},
\code{\link{splice_time}()},
\code{\link{splice_time.Duration}()},
\code{\link{splice_time.OnsetsDifference}()},
\code{\link{splice_time.View}()},
\code{\link{splice_time.list}()},
\code{\link{split.SplicedView}()}
}
\concept{splicing functions}
