% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom-tol.R
\name{custom_tol}
\alias{custom_tol}
\alias{custom_rtol}
\alias{custom_atol}
\title{Customize tolerances for specific compartments}
\usage{
custom_tol(.x, .rtol = NULL, .atol = NULL)

custom_rtol(.x, .rtol = list(), .default = NULL, .use = TRUE, ...)

custom_atol(.x, .atol = list(), .default = NULL, .use = TRUE, ...)
}
\arguments{
\item{.x}{a model object.}

\item{.rtol}{a named numeric list or vector, where names reference
selected model compartments and relative tolerances for those
compartments; \code{custom_tol()} also accepts the name of an object in the
model environment to be used.}

\item{.atol}{a named numeric list or vector, where names reference
selected model compartments and absolute tolerances for those
compartments; \code{custom_tol()} also accepts the name of an object in the
model environment to be used.}

\item{.default}{the default tolerance value to use for compartments not
listed in \code{.rtol}, \code{.atol}, or \code{...}; if not supplied, the current scalar
value in \code{.x} will be used.}

\item{.use}{\code{logical}; if \code{TRUE}, then a call to \code{\link[=use_custom_tol]{use_custom_tol()}} will be
made prior to return; if \code{FALSE}, a call to \code{\link[=use_scalar_tol]{use_scalar_tol()}} will be made;
under expected use, the value for this argument is kept \code{TRUE}, so that
whenever tolerances are customized, they will be used in the next simulation
run.}

\item{...}{\code{name}/\code{value} pairs, where \code{name} references a model compartment
and \code{value} is a new, numeric value to use for \code{rtol} or \code{atol}.}
}
\value{
An updated model object.
}
\description{
These functions update the relative or absolute tolerance values
only for the custom tolerance configuration.
}
\details{
New tolerance values can be supplied by either a named, numeric vector or
list via \code{.rtol} and \code{.atol} or via \code{...} or by both. If duplicate
compartment names are found in \code{...} and either \code{.rtol} or \code{.atol}, the value
passed via \code{...} will take precedence.

The \code{custom_tol()} function provides a mechanism for coding customized
tolerances into the model file itself. Simply create named numeric lists
or vectors for customized \code{rtol} or \code{atol} in a \verb{$ENV} block. On loading
the model, call \code{custom_tol()} and supply the names of those objects as
\code{.rtol} and \code{.atol}.
}
\examples{
mod <- house()
mod <- custom_rtol(mod, GUT = 1e-2, CENT = 1e-3)

new_tolerances <- c(GUT = 1e-4, RESP = 1e-5)
mod <- custom_rtol(mod, new_tolerances, RESP = 1e-6)

}
\seealso{
\code{\link[=reset_tol]{reset_tol()}}, \code{\link[=use_custom_tol]{use_custom_tol()}}, \code{\link[=use_scalar_tol]{use_scalar_tol()}}, \code{\link[=get_tol]{get_tol()}}
}
