% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_set.R
\name{lctran}
\alias{lctran}
\alias{lctran.data.frame}
\alias{lctran.ev}
\alias{uctran}
\alias{uctran.data.frame}
\alias{uctran.ev}
\title{Change the case of nmtran-like data items}
\usage{
lctran(data, ...)

\method{lctran}{data.frame}(data, warn = TRUE, ...)

\method{lctran}{ev}(data, ...)

uctran(data, ...)

\method{uctran}{data.frame}(data, warn = TRUE, ...)

\method{uctran}{ev}(data, ...)
}
\arguments{
\item{data}{a data set with nmtran-like format or an event object.}

\item{...}{for potential future use.}

\item{warn}{if \code{TRUE}, a warning will be issued when there are both upper
and lower case versions of any nmtran-like column in the data frame.}
}
\value{
A data frame or event object, with column names possibly converted to upper
or lower case.
}
\description{
Previous data set requirements included lower case names for data items
like \code{AMT} and \code{EVID}. Lower case is no longer required. However, it is still
a requirement that nmtran like data column names are either all lower case
or all upper case.
}
\details{
Columns that will be renamed with lower or upper case versions:
\itemize{
\item \code{AMT  / amt}
\item \code{II   / ii}
\item \code{SS   / ss}
\item \code{CMT  / cmt}
\item \code{ADDL / addl}
\item \code{RATE / rate}
\item \code{EVID / evid}
\item \code{TIME / time}
}

If both lower and upper case versions of the name are present in the data
frame, no changes will be made.
}
\examples{
data <- data.frame(TIME = 0, AMT = 5, II = 24, addl = 2, WT = 80)
lctran(data)

data <- data.frame(TIME = 0, AMT = 5, II = 24, addl = 2, wt = 80)
uctran(data)

ev <- evd(amt = 100, evid = 3)
uctran(ev)

# warning
data <- data.frame(TIME = 1, time = 2, CMT = 5)
lctran(data)

}
